/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import net.finmath.time.Period;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.daycount.DayCountConventionInterface;
import net.finmath.time.daycount.DayCountConvention_ACT_365;

public class Schedule
implements ScheduleInterface {
    private static DayCountConventionInterface internalDayCounting = new DayCountConvention_ACT_365();
    private Calendar referenceDate;
    private List<Period> periods;
    private DayCountConventionInterface daycountconvention;
    private double[] fixingTimes;
    private double[] paymentTimes;
    private double[] periodStartTimes;
    private double[] periodEndTimes;
    private double[] periodLength;

    public Schedule(Calendar calendar, DayCountConventionInterface dayCountConventionInterface, Period ... periodArray) {
        this(calendar, Arrays.asList(periodArray), dayCountConventionInterface);
    }

    public Schedule(Calendar calendar, List<Period> list, DayCountConventionInterface dayCountConventionInterface) {
        this.referenceDate = calendar;
        this.periods = list;
        this.daycountconvention = dayCountConventionInterface;
        this.fixingTimes = new double[list.size()];
        this.paymentTimes = new double[list.size()];
        this.periodStartTimes = new double[list.size()];
        this.periodEndTimes = new double[list.size()];
        this.periodLength = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.fixingTimes[i] = internalDayCounting.getDaycountFraction(calendar, list.get(i).getFixing());
            this.paymentTimes[i] = internalDayCounting.getDaycountFraction(calendar, list.get(i).getPayment());
            this.periodStartTimes[i] = internalDayCounting.getDaycountFraction(calendar, list.get(i).getPeriodStart());
            this.periodEndTimes[i] = internalDayCounting.getDaycountFraction(calendar, list.get(i).getPeriodEnd());
            this.periodLength[i] = dayCountConventionInterface.getDaycountFraction(list.get(i).getPeriodStart(), list.get(i).getPeriodEnd());
        }
    }

    @Override
    public Calendar getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public List<Period> getPeriods() {
        return this.periods;
    }

    @Override
    public DayCountConventionInterface getDaycountconvention() {
        return this.daycountconvention;
    }

    @Override
    public int getNumberOfPeriods() {
        return this.periods.size();
    }

    @Override
    public Period getPeriod(int n) {
        return this.periods.get(n);
    }

    @Override
    public double getFixing(int n) {
        return this.fixingTimes[n];
    }

    @Override
    public double getPayment(int n) {
        return this.paymentTimes[n];
    }

    @Override
    public double getPeriodStart(int n) {
        return this.periodStartTimes[n];
    }

    @Override
    public double getPeriodEnd(int n) {
        return this.periodEndTimes[n];
    }

    @Override
    public double getPeriodLength(int n) {
        return this.periodLength[n];
    }

    public String toString() {
        return "Schedule [referenceDate=" + this.referenceDate.getTime() + ", periods=" + this.periods + ", daycountconvention=" + this.daycountconvention + "]";
    }

    @Override
    public Iterator<Period> iterator() {
        return this.periods.iterator();
    }
}

