/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.montecarlo.interestrate;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.MonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModelExponentialDecay;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCovarianceModelExponentialForm7Param;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCovarianceModelFromVolatilityAndCorrelation;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModelFromGivenMatrix;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.Bond;
import net.finmath.montecarlo.interestrate.products.DigitalCaplet;
import net.finmath.montecarlo.interestrate.products.SimpleSwap;
import net.finmath.montecarlo.interestrate.products.Swaption;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximation;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximationRebonato;
import net.finmath.montecarlo.process.AbstractProcess;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LIBORMarketModelMultiCurveValuationTest {
    private final int numberOfPaths = 100000;
    private final int numberOfFactors = 6;
    private LIBORModelMonteCarloSimulationInterface liborMarketModel;
    private static DecimalFormat formatterMaturity = new DecimalFormat("00.00", new DecimalFormatSymbols(Locale.ENGLISH));
    private static DecimalFormat formatterValue = new DecimalFormat(" ##0.000%;-##0.000%", new DecimalFormatSymbols(Locale.ENGLISH));
    private static DecimalFormat formatterDeviation = new DecimalFormat(" 0.00000E00;-0.00000E00", new DecimalFormatSymbols(Locale.ENGLISH));

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        return Arrays.asList({LIBORMarketModel.Measure.SPOT}, {LIBORMarketModel.Measure.TERMINAL});
    }

    public LIBORMarketModelMultiCurveValuationTest(LIBORMarketModel.Measure measure) throws CalculationException {
        this.liborMarketModel = LIBORMarketModelMultiCurveValuationTest.createLIBORMarketModel(measure, 100000, 6, 0.1);
    }

    public static LIBORModelMonteCarloSimulationInterface createLIBORMarketModel(LIBORMarketModel.Measure measure, int n, int n2, double d) throws CalculationException {
        double d2 = 0.5;
        double d3 = 20.0;
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, (int)(d3 / d2), d2);
        ForwardCurve forwardCurve = ForwardCurve.createForwardCurveFromForwards("forwardCurve", new double[]{0.5, 1.0, 2.0, 5.0, 40.0}, new double[]{0.05, 0.05, 0.05, 0.05, 0.05}, d2);
        DiscountCurve discountCurve = DiscountCurve.createDiscountCurveFromZeroRates("discountCurve", new double[]{0.5, 1.0, 2.0, 5.0, 40.0}, new double[]{0.04, 0.04, 0.04, 0.04, 0.05});
        double d4 = 20.0;
        double d5 = 0.5;
        TimeDiscretization timeDiscretization2 = new TimeDiscretization(0.0, (int)(d4 / d5), d5);
        double[][] dArray = new double[timeDiscretization2.getNumberOfTimeSteps()][timeDiscretization.getNumberOfTimeSteps()];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                double d6 = timeDiscretization2.getTime(i);
                double d7 = timeDiscretization.getTime(j);
                double d8 = d7 - d6;
                double d9 = d8 <= 0.0 ? 0.0 : 0.3 + 0.2 * Math.exp(-0.25 * d8);
                dArray[i][j] = d9;
            }
        }
        LIBORVolatilityModelFromGivenMatrix lIBORVolatilityModelFromGivenMatrix = new LIBORVolatilityModelFromGivenMatrix(timeDiscretization2, timeDiscretization, dArray);
        LIBORCorrelationModelExponentialDecay lIBORCorrelationModelExponentialDecay = new LIBORCorrelationModelExponentialDecay(timeDiscretization2, timeDiscretization, n2, d);
        LIBORCovarianceModelFromVolatilityAndCorrelation lIBORCovarianceModelFromVolatilityAndCorrelation = new LIBORCovarianceModelFromVolatilityAndCorrelation(timeDiscretization2, timeDiscretization, lIBORVolatilityModelFromGivenMatrix, lIBORCorrelationModelExponentialDecay);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("measure", measure.name());
        hashMap.put("stateSpace", LIBORMarketModel.StateSpace.LOGNORMAL.name());
        LIBORMarketModel.CalibrationItem[] calibrationItemArray = new LIBORMarketModel.CalibrationItem[]{};
        LIBORMarketModel lIBORMarketModel = new LIBORMarketModel((TimeDiscretizationInterface)timeDiscretization, (ForwardCurveInterface)forwardCurve, (DiscountCurveInterface)discountCurve, (AbstractLIBORCovarianceModel)lIBORCovarianceModelFromVolatilityAndCorrelation, calibrationItemArray, hashMap);
        ProcessEulerScheme processEulerScheme = new ProcessEulerScheme(new BrownianMotion(timeDiscretization2, n2, n, 3141));
        return new LIBORModelMonteCarloSimulation(lIBORMarketModel, processEulerScheme);
    }

    @Test
    public void testBond() throws CalculationException {
        System.out.println("Bond prices:\n");
        System.out.println("Maturity      Simulation       Analytic        Deviation");
        double d = 0.0;
        for (int i = 0; i <= this.liborMarketModel.getNumberOfLibors(); ++i) {
            double d2 = this.liborMarketModel.getLiborPeriod(i);
            System.out.print(formatterMaturity.format(d2) + "          ");
            Bond bond = new Bond(d2);
            double d3 = bond.getValue(this.liborMarketModel);
            System.out.print(formatterValue.format(d3) + "          ");
            double d4 = this.liborMarketModel.getModel().getDiscountCurve().getDiscountFactor(d2);
            System.out.print(formatterValue.format(d4) + "          ");
            double d5 = d3 - d4;
            System.out.println(formatterDeviation.format(d5));
            d = Math.max(d, Math.abs(d5));
        }
        System.out.println("Maximum abs deviation: " + formatterDeviation.format(d));
        System.out.println("__________________________________________________________________________________________\n");
        Assert.assertTrue((d < 0.005 ? 1 : 0) != 0);
    }

    @Test
    public void testSwap() throws CalculationException {
        System.out.println("Par-Swap prices:\n");
        System.out.println("Swap \t\t\t Value");
        double d = 0.0;
        for (int i = 1; i <= this.liborMarketModel.getNumberOfLibors() - 10; ++i) {
            double d2 = this.liborMarketModel.getLiborPeriod(i);
            int n = 5;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n + 1];
            double d3 = 1.0;
            for (int j = 0; j < n; ++j) {
                dArray[j] = d2 + (double)j * d3;
                dArray2[j] = d2 + (double)(j + 1) * d3;
                dArray3[j] = d2 + (double)j * d3;
            }
            dArray3[n] = d2 + (double)n * d3;
            System.out.print("(" + formatterMaturity.format(dArray3[0]) + "," + formatterMaturity.format(dArray3[n - 1]) + "," + d3 + ")" + "\t");
            double d4 = LIBORMarketModelMultiCurveValuationTest.getParSwaprate(this.liborMarketModel, dArray3);
            double[] dArray4 = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray4[j] = d4;
            }
            SimpleSwap simpleSwap = new SimpleSwap(dArray, dArray2, dArray4);
            double d5 = simpleSwap.getValue(this.liborMarketModel);
            System.out.print(formatterValue.format(d5) + "\n");
            d = Math.max(d, Math.abs(d5));
        }
        System.out.println("Maximum abs deviation: " + formatterDeviation.format(d));
        System.out.println("__________________________________________________________________________________________\n");
        Assert.assertTrue((d < 0.005 ? 1 : 0) != 0);
    }

    @Test
    public void testDigitalCaplet() throws CalculationException {
        System.out.println("Digital caplet prices:\n");
        System.out.println("Maturity      Simulation       Analytic        Deviation");
        double d = 0.0;
        for (int i = 1; i <= this.liborMarketModel.getNumberOfLibors() - 10; ++i) {
            double d2 = this.liborMarketModel.getLiborPeriod(i);
            System.out.print(formatterMaturity.format(d2) + "          ");
            double d3 = this.liborMarketModel.getLiborPeriod(i);
            double d4 = this.liborMarketModel.getLiborPeriod(i + 1);
            double d5 = 0.02;
            DigitalCaplet digitalCaplet = new DigitalCaplet(d2, d3, d4, d5);
            double d6 = digitalCaplet.getValue(this.liborMarketModel);
            System.out.print(formatterValue.format(d6) + "          ");
            double d7 = LIBORMarketModelMultiCurveValuationTest.getParSwaprate(this.liborMarketModel, new double[]{d3, d4});
            double d8 = d4 - d3;
            double d9 = LIBORMarketModelMultiCurveValuationTest.getSwapAnnuity(this.liborMarketModel, new double[]{d3, d4}) / d8;
            int n = this.liborMarketModel.getTimeIndex(d2);
            int n2 = this.liborMarketModel.getLiborPeriodIndex(d3);
            double d10 = Math.sqrt(this.liborMarketModel.getModel().getIntegratedLIBORCovariance()[n][n2][n2] / d2);
            double d11 = AnalyticFormulas.blackModelDgitialCapletValue(d7, d10, d8, d9, d2, d5);
            System.out.print(formatterValue.format(d11) + "          ");
            double d12 = d6 - d11;
            System.out.println(formatterDeviation.format(d12) + "          ");
            d = Math.max(d, Math.abs(d12));
        }
        System.out.println("__________________________________________________________________________________________\n");
        Assert.assertTrue((Math.abs(d) < 0.05 ? 1 : 0) != 0);
    }

    @Test
    public void testSwaption() throws CalculationException {
        System.out.println("Swaption prices:\n");
        System.out.println("Maturity      Simulation       Analytic 1       Analytic 2       Deviation 1           Deviation 2");
        double d = 0.0;
        for (int i = 1; i <= this.liborMarketModel.getNumberOfLibors() - 10; ++i) {
            double d2 = this.liborMarketModel.getLiborPeriod(i);
            System.out.print(formatterMaturity.format(d2) + "          ");
            int n = 5;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n + 1];
            double d3 = 0.5;
            for (int j = 0; j < n; ++j) {
                dArray[j] = d2 + (double)j * d3;
                dArray2[j] = d2 + (double)(j + 1) * d3;
                dArray3[j] = d2 + (double)j * d3;
            }
            dArray3[n] = d2 + (double)n * d3;
            double d4 = LIBORMarketModelMultiCurveValuationTest.getParSwaprate(this.liborMarketModel, dArray3);
            double[] dArray4 = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray4[j] = d4;
            }
            Swaption swaption = new Swaption(d2, dArray, dArray2, dArray4);
            double d5 = swaption.getValue(this.liborMarketModel);
            System.out.print(formatterValue.format(d5) + "          ");
            SwaptionAnalyticApproximation swaptionAnalyticApproximation = new SwaptionAnalyticApproximation(d4, dArray3, SwaptionAnalyticApproximation.ValueUnit.VALUE);
            double d6 = swaptionAnalyticApproximation.getValue(this.liborMarketModel);
            System.out.print(formatterValue.format(d6) + "          ");
            SwaptionAnalyticApproximationRebonato swaptionAnalyticApproximationRebonato = new SwaptionAnalyticApproximationRebonato(d4, dArray3, SwaptionAnalyticApproximationRebonato.ValueUnit.VALUE);
            double d7 = swaptionAnalyticApproximationRebonato.getValue(this.liborMarketModel);
            System.out.print(formatterValue.format(d7) + "          ");
            double d8 = d5 - d6;
            System.out.print(formatterDeviation.format(d8) + "          ");
            double d9 = d6 - d7;
            System.out.println(formatterDeviation.format(d9) + "          ");
            d = Math.max(d, Math.abs(d8));
            d = Math.max(d, Math.abs(d9));
        }
        System.out.println("Maximum abs deviation: " + formatterDeviation.format(d));
        System.out.println("__________________________________________________________________________________________\n");
        Assert.assertTrue((Math.abs(d) < 0.008 ? 1 : 0) != 0);
    }

    @Test
    public void testSwaptionSmile() throws CalculationException {
        System.out.println("Swaption prices:\n");
        System.out.println("Moneyness      Simulation       Analytic        Deviation");
        double d = 5.0;
        int n = 10;
        double d2 = 0.5;
        double d3 = 0.0;
        for (double d4 = 0.5; d4 < 2.0; d4 += 0.1) {
            double d5 = d;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n + 1];
            for (int i = 0; i < n; ++i) {
                dArray[i] = d5 + (double)i * d2;
                dArray2[i] = d5 + (double)(i + 1) * d2;
                dArray3[i] = d5 + (double)i * d2;
            }
            dArray3[n] = d5 + (double)n * d2;
            double d6 = d4 * LIBORMarketModelMultiCurveValuationTest.getParSwaprate(this.liborMarketModel, dArray3);
            double[] dArray4 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray4[i] = d6;
            }
            Swaption swaption = new Swaption(d5, dArray, dArray2, dArray4);
            SwaptionAnalyticApproximation swaptionAnalyticApproximation = new SwaptionAnalyticApproximation(d6, dArray3, SwaptionAnalyticApproximation.ValueUnit.VALUE);
            System.out.print(formatterValue.format(d4) + "          ");
            double d7 = swaption.getValue(this.liborMarketModel);
            double d8 = AnalyticFormulas.blackScholesOptionImpliedVolatility(LIBORMarketModelMultiCurveValuationTest.getParSwaprate(this.liborMarketModel, dArray3), d5, d6, LIBORMarketModelMultiCurveValuationTest.getSwapAnnuity(this.liborMarketModel, dArray3), d7);
            System.out.print(formatterValue.format(d8) + "          ");
            double d9 = swaptionAnalyticApproximation.getValue(this.liborMarketModel);
            double d10 = AnalyticFormulas.blackScholesOptionImpliedVolatility(LIBORMarketModelMultiCurveValuationTest.getParSwaprate(this.liborMarketModel, dArray3), d5, d6, LIBORMarketModelMultiCurveValuationTest.getSwapAnnuity(this.liborMarketModel, dArray3), d9);
            System.out.print(formatterValue.format(d10) + "          ");
            double d11 = d8 - d10;
            System.out.println(formatterDeviation.format(d11) + "          ");
            d3 = Math.max(d3, Math.abs(d11));
        }
        System.out.println("Maximum abs deviation: " + formatterDeviation.format(d3));
        System.out.println("__________________________________________________________________________________________\n");
        Assert.assertTrue((Math.abs(d3) < 0.1 ? 1 : 0) != 0);
    }

    @Test
    public void testSwaptionCalibration() throws CalculationException {
        int n;
        double[] dArray;
        double d;
        Object object;
        Object object2;
        Object object3;
        System.out.println("Calibration to Swaptions:");
        ArrayList<LIBORMarketModel.CalibrationItem> arrayList = new ArrayList<LIBORMarketModel.CalibrationItem>();
        for (int i = 4; i <= this.liborMarketModel.getNumberOfLibors() - 5; i += 4) {
            double d2 = this.liborMarketModel.getLiborPeriod(i);
            for (int j = 1; j < this.liborMarketModel.getNumberOfLibors() - i - 5; j += 4) {
                AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct;
                object3 = new double[j];
                object2 = new double[j];
                object = new double[j + 1];
                double d3 = 0.5;
                for (int k = 0; k < j; ++k) {
                    object3[k] = d2 + (double)k * d3;
                    object2[k] = d2 + (double)(k + 1) * d3;
                    object[k] = d2 + (double)k * d3;
                }
                object[j] = d2 + (double)j * d3;
                double d4 = LIBORMarketModelMultiCurveValuationTest.getParSwaprate(this.liborMarketModel, object);
                double[] dArray2 = new double[j];
                Arrays.fill(dArray2, d4);
                d = 0.2 + 0.2 * Math.exp(-d2 / 10.0) + 0.2 * Math.exp(-(d2 + (double)j) / 10.0);
                boolean bl = true;
                if (bl) {
                    abstractLIBORMonteCarloProduct = new SwaptionAnalyticApproximation(d4, (double[])object, SwaptionAnalyticApproximation.ValueUnit.VOLATILITY);
                    arrayList.add(new LIBORMarketModel.CalibrationItem(abstractLIBORMonteCarloProduct, d, 1.0));
                    continue;
                }
                abstractLIBORMonteCarloProduct = new Swaption(d2, (double[])object3, (double[])object2, dArray2);
                double d5 = AnalyticFormulas.blackModelSwaptionValue(d4, d, (double)object3[0], d4, LIBORMarketModelMultiCurveValuationTest.getSwapAnnuity(this.liborMarketModel, object));
                arrayList.add(new LIBORMarketModel.CalibrationItem(abstractLIBORMonteCarloProduct, d5, 1.0));
            }
        }
        System.out.println("");
        TimeDiscretizationInterface timeDiscretizationInterface = this.liborMarketModel.getTimeDiscretization();
        DiscountCurveInterface discountCurveInterface = this.liborMarketModel.getModel().getDiscountCurve();
        ForwardCurveInterface forwardCurveInterface = this.liborMarketModel.getModel().getForwardRateCurve();
        LIBORCovarianceModelExponentialForm7Param lIBORCovarianceModelExponentialForm7Param = new LIBORCovarianceModelExponentialForm7Param(timeDiscretizationInterface, this.liborMarketModel.getLiborPeriodDiscretization(), this.liborMarketModel.getNumberOfFactors());
        object3 = new LIBORMarketModel(this.liborMarketModel.getLiborPeriodDiscretization(), forwardCurveInterface, discountCurveInterface, (AbstractLIBORCovarianceModel)lIBORCovarianceModelExponentialForm7Param, arrayList.toArray(new LIBORMarketModel.CalibrationItem[0]), null);
        object2 = new ProcessEulerScheme(new BrownianMotion(timeDiscretizationInterface, 6, 100000, 3141));
        ((ProcessEulerScheme)object2).setScheme(ProcessEulerScheme.Scheme.PREDICTOR_CORRECTOR);
        object = new LIBORModelMonteCarloSimulation((LIBORMarketModelInterface)object3, (AbstractProcess)object2);
        double[] dArray3 = dArray = ((AbstractLIBORCovarianceModelParametric)((LIBORMarketModel)object3).getCovarianceModel()).getParameter();
        int n2 = dArray3.length;
        for (n = 0; n < n2; ++n) {
            double d6 = dArray3[n];
            System.out.println(d6);
        }
        double d7 = 0.0;
        for (n = 0; n < arrayList.size(); ++n) {
            AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct = ((LIBORMarketModel.CalibrationItem)arrayList.get((int)n)).calibrationProduct;
            d = abstractLIBORMonteCarloProduct.getValue((MonteCarloSimulationInterface)object);
            double d8 = ((LIBORMarketModel.CalibrationItem)arrayList.get((int)n)).calibrationTargetValue;
            d7 += d - d8;
            System.out.println("Model: " + formatterValue.format(d) + "\t Target: " + formatterValue.format(d8) + "\t Deviation: " + formatterDeviation.format(d - d8));
        }
        System.out.println("Mean Deviation:" + d7 / (double)arrayList.size());
        System.out.println("__________________________________________________________________________________________\n");
    }

    private static double getParSwaprate(LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface, double[] dArray) throws CalculationException {
        return Swap.getForwardSwapRate(new TimeDiscretization(dArray), new TimeDiscretization(dArray), lIBORModelMonteCarloSimulationInterface.getModel().getForwardRateCurve(), lIBORModelMonteCarloSimulationInterface.getModel().getDiscountCurve());
    }

    private static double getSwapAnnuity(LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface, double[] dArray) throws CalculationException {
        return SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)new TimeDiscretization(dArray), lIBORModelMonteCarloSimulationInterface.getModel().getDiscountCurve());
    }
}

