/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.montecarlo.interestrate;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionView;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.modelplugins.BlendedLocalVolatilityModel;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCovarianceModelExponentialForm5Param;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCovarianceModelStochasticVolatility;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SwaptionSimple;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;
import org.junit.Assert;
import org.junit.Test;

public class LIBORMarketModelCalibrationTest {
    private final int numberOfPaths = 5000;
    private final int numberOfFactors = 5;
    private static DecimalFormat formatterValue = new DecimalFormat(" ##0.000%;-##0.000%", new DecimalFormatSymbols(Locale.ENGLISH));
    private static DecimalFormat formatterParam = new DecimalFormat(" #0.000;-#0.000", new DecimalFormatSymbols(Locale.ENGLISH));
    private static DecimalFormat formatterDeviation = new DecimalFormat(" 0.00000E00;-0.00000E00", new DecimalFormatSymbols(Locale.ENGLISH));

    private LIBORMarketModel.CalibrationItem createCalibrationItem(double d, double d2, int n, double d3, double d4, ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface) throws CalculationException {
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n + 1];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d + (double)i * d2;
            dArray2[i] = d + (double)(i + 1) * d2;
            dArray3[i] = d + (double)i * d2;
        }
        dArray3[n] = d + (double)n * d2;
        double d5 = d3 + LIBORMarketModelCalibrationTest.getParSwaprate(forwardCurveInterface, discountCurveInterface, dArray3);
        double[] dArray4 = new double[n];
        Arrays.fill(dArray4, d5);
        SwaptionSimple swaptionSimple = new SwaptionSimple(d5, dArray3, SwaptionSimple.ValueUnit.VOLATILITY);
        return new LIBORMarketModel.CalibrationItem(swaptionSimple, d4, 1.0);
    }

    @Test
    public void testSwaptionSmileCalibration() throws CalculationException {
        double d;
        double d2;
        double d3;
        System.out.println("Calibration to Swaptions:");
        double[] dArray = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, 10.0, 10.5, 11.0, 11.5, 12.0, 12.5, 13.0, 13.5, 14.0, 14.5, 15.0, 15.5, 16.0, 16.5, 17.0, 17.5, 18.0, 18.5, 19.0, 19.5, 20.0, 20.5, 21.0, 21.5, 22.0, 22.5, 23.0, 23.5, 24.0, 24.5, 25.0, 25.5, 26.0, 26.5, 27.0, 27.5, 28.0, 28.5, 29.0, 29.5, 30.0, 30.5, 31.0, 31.5, 32.0, 32.5, 33.0, 33.5, 34.0, 34.5, 35.0, 35.5, 36.0, 36.5, 37.0, 37.5, 38.0, 38.5, 39.0, 39.5, 40.0, 40.5, 41.0, 41.5, 42.0, 42.5, 43.0, 43.5, 44.0, 44.5, 45.0, 45.5, 46.0, 46.5, 47.0, 47.5, 48.0, 48.5, 49.0, 49.5, 50.0};
        double[] dArray2 = new double[]{0.0060999999999999995, 0.0060999999999999995, 0.0067, 0.0073, 0.008, 0.0092, 0.0111, 0.013600000000000001, 0.016, 0.0182, 0.0202, 0.0217, 0.0227, 0.0236, 0.0246, 0.0252, 0.0254, 0.025699999999999997, 0.0268, 0.0282, 0.0292, 0.0298, 0.03, 0.029900000000000003, 0.029500000000000002, 0.028900000000000002, 0.0282, 0.0274, 0.026600000000000002, 0.0259, 0.0252, 0.024700000000000003, 0.0242, 0.023799999999999998, 0.0235, 0.0233, 0.0231, 0.023, 0.0229, 0.022799999999999997, 0.0227, 0.0227, 0.0226, 0.0226, 0.0226, 0.0226, 0.0226, 0.0226, 0.0227, 0.022799999999999997, 0.022799999999999997, 0.023, 0.0231, 0.0232, 0.023399999999999997, 0.0235, 0.023700000000000002, 0.0239, 0.0242, 0.024399999999999998, 0.024700000000000003, 0.025, 0.0252, 0.0256, 0.0259, 0.0262, 0.0265, 0.0268, 0.027200000000000002, 0.0275, 0.0278, 0.0281, 0.028300000000000002, 0.0286, 0.0288, 0.0291, 0.029300000000000003, 0.0294, 0.0296, 0.0297, 0.0297, 0.0297, 0.0297, 0.0297, 0.0296, 0.029500000000000002, 0.0294, 0.029300000000000003, 0.0291, 0.028900000000000002, 0.0287, 0.0285, 0.028300000000000002, 0.027999999999999997, 0.0278, 0.0275, 0.027200000000000002, 0.0269, 0.026699999999999998, 0.0264, 0.0264};
        double d4 = 0.5;
        ForwardCurve forwardCurve = ForwardCurve.createForwardCurveFromForwards("forwardCurve", dArray, dArray2, d4);
        DiscountCurveFromForwardCurve discountCurveFromForwardCurve = new DiscountCurveFromForwardCurve(forwardCurve, d4);
        ArrayList<LIBORMarketModel.CalibrationItem> arrayList = new ArrayList<LIBORMarketModel.CalibrationItem>();
        double d5 = 0.5;
        int n = 20;
        double[] dArray3 = new double[]{-0.02, -0.01, -0.005, -0.0025, 0.0, 0.0025, 0.005, 0.01, 0.02};
        double[] dArray4 = new double[]{0.559, 0.377, 0.335, 0.32, 0.308, 0.298, 0.29, 0.28, 0.27};
        for (int i = 0; i < dArray3.length; ++i) {
            double d6 = 5.0;
            d3 = dArray3[i];
            d2 = dArray4[i];
            arrayList.add(this.createCalibrationItem(d6, d5, n, d3, d2, forwardCurve, discountCurveFromForwardCurve));
        }
        double[] dArray5 = new double[]{2.0, 3.0, 4.0, 5.0, 7.0, 10.0, 15.0, 20.0, 25.0, 30.0};
        double[] dArray6 = new double[]{0.385, 0.351, 0.325, 0.308, 0.288, 0.279, 0.29, 0.272, 0.235, 0.192};
        for (int i = 0; i < dArray5.length; ++i) {
            d3 = dArray5[i];
            d2 = 0.0;
            d = dArray6[i];
            arrayList.add(this.createCalibrationItem(d3, d5, n, d2, d, forwardCurve, discountCurveFromForwardCurve));
        }
        double d7 = 20.0;
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, (int)(d7 / d4), d4);
        d2 = 20.0;
        d = 0.5;
        TimeDiscretization timeDiscretization2 = new TimeDiscretization(0.0, (int)(d2 / d), d);
        BrownianMotion brownianMotion = new BrownianMotion(timeDiscretization2, 6, 5000, 31415);
        BrownianMotionView brownianMotionView = new BrownianMotionView(brownianMotion, new Integer[]{0, 1, 2, 3, 4});
        BrownianMotionView brownianMotionView2 = new BrownianMotionView(brownianMotion, new Integer[]{0, 5});
        LIBORCovarianceModelExponentialForm5Param lIBORCovarianceModelExponentialForm5Param = new LIBORCovarianceModelExponentialForm5Param(timeDiscretization2, timeDiscretization, 5, new double[]{0.2, 0.05, 0.1, 0.05, 0.1});
        BlendedLocalVolatilityModel blendedLocalVolatilityModel = new BlendedLocalVolatilityModel(lIBORCovarianceModelExponentialForm5Param, 0.0, false);
        LIBORCovarianceModelStochasticVolatility lIBORCovarianceModelStochasticVolatility = new LIBORCovarianceModelStochasticVolatility(blendedLocalVolatilityModel, brownianMotionView2, 0.01, -0.3, true);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("measure", LIBORMarketModel.Measure.SPOT.name());
        hashMap.put("stateSpace", LIBORMarketModel.StateSpace.NORMAL.name());
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("accuracyParameter", new Double(1.0E-8));
        hashMap2.put("brownianMotion", brownianMotionView);
        hashMap.put("calibrationParameters", hashMap2);
        LIBORMarketModel lIBORMarketModel = new LIBORMarketModel((TimeDiscretizationInterface)timeDiscretization, (ForwardCurveInterface)forwardCurve, null, (AbstractLIBORCovarianceModel)lIBORCovarianceModelStochasticVolatility, arrayList.toArray(new LIBORMarketModel.CalibrationItem[0]), hashMap);
        System.out.println("\nCalibrated parameters are:");
        double[] dArray7 = ((AbstractLIBORCovarianceModelParametric)lIBORMarketModel.getCovarianceModel()).getParameter();
        ((AbstractLIBORCovarianceModelParametric)lIBORMarketModel.getCovarianceModel()).setParameter(dArray7);
        for (double d6 : dArray7) {
            System.out.println(formatterParam.format(d6));
        }
        ProcessEulerScheme processEulerScheme = new ProcessEulerScheme(brownianMotionView);
        LIBORModelMonteCarloSimulation lIBORModelMonteCarloSimulation = new LIBORModelMonteCarloSimulation(lIBORMarketModel, processEulerScheme);
        System.out.println("\nValuation on calibrated model:");
        double d8 = 0.0;
        for (int d12 = 0; d12 < arrayList.size(); ++d12) {
            AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct = ((LIBORMarketModel.CalibrationItem)arrayList.get((int)d12)).calibrationProduct;
            try {
                double exception = abstractLIBORMonteCarloProduct.getValue(lIBORModelMonteCarloSimulation);
                double d9 = ((LIBORMarketModel.CalibrationItem)arrayList.get((int)d12)).calibrationTargetValue;
                d8 += exception - d9;
                System.out.println("Model: " + formatterValue.format(exception) + "\t Target: " + formatterValue.format(d9) + "\t Deviation: " + formatterDeviation.format(exception - d9) + "\t" + abstractLIBORMonteCarloProduct.toString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        double d10 = d8 / (double)arrayList.size();
        System.out.println("Mean Deviation:" + formatterValue.format(d10));
        System.out.println("__________________________________________________________________________________________\n");
        Assert.assertTrue((Math.abs(d10) < 0.01 ? 1 : 0) != 0);
    }

    private static double getParSwaprate(ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface, double[] dArray) throws CalculationException {
        return Swap.getForwardSwapRate(new TimeDiscretization(dArray), new TimeDiscretization(dArray), forwardCurveInterface, discountCurveInterface);
    }
}

