/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.montecarlo.assetderivativevaluation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloBlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AsianOption;
import net.finmath.montecarlo.assetderivativevaluation.products.BermudanOption;
import net.finmath.montecarlo.assetderivativevaluation.products.EuropeanOption;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;
import org.junit.Assert;
import org.junit.Test;

public class BlackScholesMonteCarloValuationTest {
    private final double initialValue = 1.0;
    private final double riskFreeRate = 0.05;
    private final double volatility = 0.3;
    private final int numberOfPaths = 20000;
    private final int numberOfTimeSteps = 10;
    private final double deltaT = 0.5;
    private AssetModelMonteCarloSimulationInterface model = this.getModel();

    public static void main(String[] stringArray) throws CalculationException, InterruptedException {
        BlackScholesMonteCarloValuationTest blackScholesMonteCarloValuationTest = new BlackScholesMonteCarloValuationTest();
        int n = BlackScholesMonteCarloValuationTest.readTestNumber();
        long l = System.currentTimeMillis();
        switch (n) {
            case 1: {
                blackScholesMonteCarloValuationTest.testEuropeanCall();
                break;
            }
            case 2: {
                blackScholesMonteCarloValuationTest.testModelProperties();
                break;
            }
            case 3: {
                blackScholesMonteCarloValuationTest.testModelRandomVariable();
                break;
            }
            case 4: {
                blackScholesMonteCarloValuationTest.testEuropeanAsianBermudanOption();
                break;
            }
            case 5: {
                blackScholesMonteCarloValuationTest.testMultiThreaddedValuation();
                break;
            }
            case 6: {
                blackScholesMonteCarloValuationTest.testEuropeanCallDelta();
                break;
            }
            case 7: {
                blackScholesMonteCarloValuationTest.testEuropeanCallVega();
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("\nCalculation time required: " + (double)(l2 - l) / 1000.0 + " seconds.");
    }

    private static int readTestNumber() {
        System.out.println("Please select a test to run (click in this window and enter a number):");
        System.out.println("\t 1: Valuation of European call options (with different strikes).");
        System.out.println("\t 2: Some model properties.");
        System.out.println("\t 3: Print some realizations of the S(1).");
        System.out.println("\t 4: Valuation of European, Asian, Bermudan option.");
        System.out.println("\t 5: Multi-Threadded valuation of some ten thousand Asian options.");
        System.out.println("\t 6: Sensitivity (Delta) of European call options (with different strikes) using different methods.");
        System.out.println("\t 7: Sensitivity (Vega) of European call options (with different strikes) using different methods.");
        System.out.println("");
        System.out.print("Test to run: ");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        int n = 0;
        try {
            String string = bufferedReader.readLine();
            n = Integer.valueOf(string);
        }
        catch (IOException iOException) {
            System.out.println("IO error trying to read test number!");
            System.exit(1);
        }
        System.out.println("");
        return n;
    }

    public AssetModelMonteCarloSimulationInterface getModel() {
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, 10, 0.5);
        MonteCarloBlackScholesModel monteCarloBlackScholesModel = new MonteCarloBlackScholesModel(timeDiscretization, 20000, 1.0, 0.05, 0.3);
        return monteCarloBlackScholesModel;
    }

    @Test
    public void testEuropeanCall() throws CalculationException {
        MonteCarloBlackScholesModel monteCarloBlackScholesModel = (MonteCarloBlackScholesModel)this.model;
        DecimalFormat decimalFormat = new DecimalFormat("     0.00 ");
        DecimalFormat decimalFormat2 = new DecimalFormat(" 0.00E00");
        DecimalFormat decimalFormat3 = new DecimalFormat("  0.00E00; -0.00E00");
        System.out.println("Valuation of European Options");
        System.out.println(" Strike \t Monte-Carlo \t Analytic \t Deviation");
        double d = monteCarloBlackScholesModel.getAssetValue(0.0, 0).get(0);
        double d2 = monteCarloBlackScholesModel.getRiskFreeRate();
        double d3 = monteCarloBlackScholesModel.getVolatility();
        double d4 = 1.0;
        for (double d5 = 0.6; d5 < 1.5; d5 += 0.05) {
            EuropeanOption europeanOption = new EuropeanOption(d4, d5);
            double d6 = europeanOption.getValue(monteCarloBlackScholesModel);
            double d7 = AnalyticFormulas.blackScholesOptionValue(d, d2, d3, d4, d5);
            System.out.println(decimalFormat.format(d5) + "\t" + decimalFormat2.format(d6) + "\t" + decimalFormat2.format(d7) + "\t" + decimalFormat3.format(d6 - d7));
            Assert.assertTrue((Math.abs(d6 - d7) < 0.01 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testModelProperties() throws CalculationException {
        System.out.println("Time \tAverage \t\tVariance");
        TimeDiscretizationInterface timeDiscretizationInterface = this.model.getTimeDiscretization();
        Iterator iterator = timeDiscretizationInterface.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            RandomVariableInterface randomVariableInterface = this.model.getAssetValue(d, 0);
            double d2 = randomVariableInterface.getAverage();
            double d3 = randomVariableInterface.getVariance();
            double d4 = randomVariableInterface.getStandardError();
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            DecimalFormat decimalFormat2 = new DecimalFormat("0.0000");
            System.out.println(decimalFormat.format(d) + " \t" + decimalFormat2.format(d2) + "\t+/- " + decimalFormat2.format(d4) + "\t" + decimalFormat2.format(d3));
        }
    }

    @Test
    public void testModelRandomVariable() throws CalculationException {
        RandomVariableInterface randomVariableInterface = this.model.getAssetValue(1.0, 0);
        System.out.println("The first 100 realizations of the " + randomVariableInterface.size() + " realizations of S(1) are:");
        System.out.println("Path\tValue");
        for (int i = 0; i < 100; ++i) {
            System.out.println(i + "\t" + randomVariableInterface.get(i));
        }
    }

    @Test
    public void testEuropeanAsianBermudanOption() throws CalculationException {
        double d = 3.0;
        double d2 = 1.07;
        EuropeanOption europeanOption = new EuropeanOption(d, d2);
        double d3 = europeanOption.getValue(this.model);
        double[] dArray = new double[]{1.0, 1.5, 2.0, 2.5, 3.0};
        AsianOption asianOption = new AsianOption(d, d2, new TimeDiscretization(dArray));
        double d4 = asianOption.getValue(this.model);
        double[] dArray2 = new double[]{1.0, 2.0, 3.0};
        double[] dArray3 = new double[]{1.2, 1.1, 1.0};
        double[] dArray4 = new double[]{1.03, 1.05, 1.07};
        BermudanOption bermudanOption = new BermudanOption(dArray2, dArray3, dArray4, BermudanOption.ExerciseMethod.ESTIMATE_COND_EXPECTATION);
        double d5 = bermudanOption.getValue(this.model);
        BermudanOption bermudanOption2 = new BermudanOption(dArray2, dArray3, dArray4, BermudanOption.ExerciseMethod.UPPER_BOUND_METHOD);
        double d6 = bermudanOption2.getValue(this.model);
        System.out.println("Value of Asian Option is \t" + d4);
        System.out.println("Value of European Option is \t" + d3);
        System.out.println("Value of Bermudan Option is \t(" + d5 + "," + d6 + ")");
        Assert.assertTrue((d4 < d3 ? 1 : 0) != 0);
        Assert.assertTrue((d5 < d6 ? 1 : 0) != 0);
        Assert.assertTrue((d3 < d6 ? 1 : 0) != 0);
    }

    public void testMultiThreaddedValuation() throws InterruptedException {
        int n;
        final double[] dArray = new double[]{0.5, 1.0, 1.5, 2.0, 2.5, 2.5, 3.0, 3.0, 3.0, 3.5, 4.5, 5.0};
        int n2 = 10;
        Thread[] threadArray = new Thread[n2];
        for (n = 0; n < threadArray.length; ++n) {
            final int n3 = n;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 10000; ++i) {
                            AsianOption asianOption = new AsianOption(5.0, 1.07, new TimeDiscretization(dArray));
                            double d = asianOption.getValue(BlackScholesMonteCarloValuationTest.this.model);
                            System.out.println("Thread " + n3 + ": Value of Asian Option " + i + " is " + d);
                        }
                    }
                    catch (CalculationException calculationException) {
                        // empty catch block
                    }
                }
            };
            threadArray[n] = new Thread(runnable);
            threadArray[n].start();
        }
        for (n = 0; n < threadArray.length; ++n) {
            threadArray[n].join();
        }
    }

    @Test
    public void testEuropeanCallDelta() throws CalculationException {
        MonteCarloBlackScholesModel monteCarloBlackScholesModel = (MonteCarloBlackScholesModel)this.model;
        DecimalFormat decimalFormat = new DecimalFormat("     0.00 ");
        DecimalFormat decimalFormat2 = new DecimalFormat(" 0.00E00");
        DecimalFormat decimalFormat3 = new DecimalFormat("  0.00E00; -0.00E00");
        double d = monteCarloBlackScholesModel.getAssetValue(0.0, 0).get(0);
        double d2 = monteCarloBlackScholesModel.getRiskFreeRate();
        double d3 = monteCarloBlackScholesModel.getVolatility();
        System.out.println("Calculation of Option Delta (European options with maturity 1.0):");
        System.out.println(" Strike \t MC Fin.Diff.\t MC Pathwise\t MC Likelihood\t Analytic \t Diff MC-FD \t Diff MC-PW \t Diff MC-LR");
        double d4 = 1.0;
        for (double d5 = 0.6; d5 < 1.5; d5 += 0.05) {
            EuropeanOption europeanOption = new EuropeanOption(d4, d5);
            double d6 = d * 1.0E-6;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("initialValue", d + d6);
            double d7 = (Double)europeanOption.getValuesForModifiedData(monteCarloBlackScholesModel, hashMap).get("value");
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("initialValue", d - d6);
            double d8 = (Double)europeanOption.getValuesForModifiedData(monteCarloBlackScholesModel, hashMap2).get("value");
            double d9 = (d7 - d8) / (2.0 * d6);
            double d10 = (AnalyticFormulas.blackScholesOptionValue(d + d6, d2, d3, d4, d5) - AnalyticFormulas.blackScholesOptionValue(d - d6, d2, d3, d4, d5)) / (2.0 * d6);
            double d11 = AnalyticFormulas.blackScholesOptionDelta(d, d2, d3, d4, d5);
            System.out.println(decimalFormat.format(d5) + "\t" + decimalFormat2.format(d9) + "\t" + decimalFormat2.format(d11) + "\t" + decimalFormat3.format(d9 - d11));
            Assert.assertTrue((Math.abs(d9 - d11) < 0.01 ? 1 : 0) != 0);
        }
        System.out.println("__________________________________________________________________________________________\n");
    }

    @Test
    public void testEuropeanCallVega() throws CalculationException {
        MonteCarloBlackScholesModel monteCarloBlackScholesModel = (MonteCarloBlackScholesModel)this.model;
        DecimalFormat decimalFormat = new DecimalFormat("     0.00 ");
        DecimalFormat decimalFormat2 = new DecimalFormat(" 0.00E00");
        DecimalFormat decimalFormat3 = new DecimalFormat("  0.00E00; -0.00E00");
        double d = monteCarloBlackScholesModel.getAssetValue(0.0, 0).get(0);
        double d2 = monteCarloBlackScholesModel.getRiskFreeRate();
        double d3 = monteCarloBlackScholesModel.getVolatility();
        System.out.println("Calculation of Option Vega (European options with maturity 1.0):");
        System.out.println(" Strike \t MC Fin.Diff.\t Analytic \t Diff MC-FD");
        double d4 = 5.0;
        for (double d5 = 0.6; d5 < 1.5; d5 += 0.05) {
            EuropeanOption europeanOption = new EuropeanOption(d4, d5);
            double d6 = d3 * 1.0E-6;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("volatility", d3 + d6);
            double d7 = (Double)europeanOption.getValuesForModifiedData(monteCarloBlackScholesModel, hashMap).get("value");
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("volatility", d3 - d6);
            double d8 = (Double)europeanOption.getValuesForModifiedData(monteCarloBlackScholesModel, hashMap2).get("value");
            double d9 = (d7 - d8) / (2.0 * d6);
            double d10 = (AnalyticFormulas.blackScholesOptionValue(d + d6, d2, d3, d4, d5) - AnalyticFormulas.blackScholesOptionValue(d - d6, d2, d3, d4, d5)) / (2.0 * d6);
            double d11 = AnalyticFormulas.blackScholesOptionVega(d, d2, d3, d4, d5);
            System.out.println(decimalFormat.format(d5) + "\t" + decimalFormat2.format(d9) + "\t" + decimalFormat2.format(d11) + "\t" + decimalFormat3.format(d9 - d11));
            Assert.assertTrue((Math.abs(d9 - d11) < 0.1 ? 1 : 0) != 0);
        }
        System.out.println("__________________________________________________________________________________________\n");
    }
}

