/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.marketdata.curves;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.SolverException;
import org.junit.Assert;
import org.junit.Test;

public class CurveTest {
    private static NumberFormat numberFormat = new DecimalFormat("0.0000");

    public static void main(String[] stringArray) throws SolverException, CloneNotSupportedException {
        new CurveTest().testCurveFitting();
    }

    @Test
    public void testCurveFitting() throws SolverException, CloneNotSupportedException {
        double d;
        Curve.CurveBuilder curveBuilder = new Curve.CurveBuilder();
        curveBuilder.setInterpolationMethod(Curve.InterpolationMethod.LINEAR);
        curveBuilder.setExtrapolationMethod(Curve.ExtrapolationMethod.LINEAR);
        curveBuilder.setInterpolationEntity(Curve.InterpolationEntity.VALUE);
        curveBuilder.addPoint(-1.0, 1.0, false);
        curveBuilder.addPoint(0.0, 1.0, false);
        curveBuilder.addPoint(0.5, 2.0, true);
        curveBuilder.addPoint(0.75, 2.0, true);
        curveBuilder.addPoint(1.0, 2.0, true);
        curveBuilder.addPoint(2.2, 2.0, true);
        curveBuilder.addPoint(3.0, 2.0, true);
        final CurveInterface curveInterface = curveBuilder.build();
        final double[] dArray = new double[]{0.0, 0.5, 0.75, 1.0, 1.5, 1.75, 2.5};
        double[] dArray2 = new double[]{3.5, 12.3, 13.2, 7.5, 5.5, 2.9, 4.4};
        LevenbergMarquardt levenbergMarquardt = new LevenbergMarquardt(curveInterface.getParameter(), dArray2, 100, Runtime.getRuntime().availableProcessors()){
            private static final long serialVersionUID = -5128114286941153154L;

            @Override
            public void setValues(double[] dArray3, double[] dArray2) throws SolverException {
                CurveInterface curveInterface2 = null;
                try {
                    curveInterface2 = curveInterface.getCloneForParameter(dArray3);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new SolverException(cloneNotSupportedException);
                }
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = curveInterface2.getValue(dArray[i]);
                }
            }
        };
        levenbergMarquardt.run();
        CurveInterface curveInterface2 = curveInterface.getCloneForParameter(levenbergMarquardt.getBestFitParameters());
        for (d = -2.0; d < 5.0; d += 0.1) {
            System.out.println(numberFormat.format(d) + "\t" + numberFormat.format(curveInterface2.getValue(d)));
        }
        d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += curveInterface2.getValue(dArray[i]) - dArray2[i];
        }
        System.out.println("Mean deviation: " + d);
        Assert.assertEquals((String)"Deviation", (double)d, (double)-2.5, (double)1.0E-5);
    }
}

