/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.convexityadjustment;

import java.text.DecimalFormat;
import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModelExponentialDecay;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCovarianceModelFromVolatilityAndCorrelation;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModelTwoParameterExponentialForm;
import net.finmath.montecarlo.interestrate.products.CMSOption;
import net.finmath.montecarlo.interestrate.products.Caplet;
import net.finmath.montecarlo.interestrate.products.Swaption;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximation;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;
import org.junit.Assert;
import org.junit.Test;

public class CMSOptionTest {
    private final double initialValue = 0.1;
    private final double volatility = 0.1;
    private final int numberOfFactors = 5;
    private final double correlationDecay = 0.1;
    private final int numberOfPaths = 10000;
    private final int numberOfTimeSteps = 15;
    private final double deltaT = 0.5;
    private final int numberOfPeriods = 30;
    private final double periodLength = 0.5;
    private final int seed = 3141;
    static final DecimalFormat formatterPercent = new DecimalFormat("0.0000%");

    @Test
    public void testCMSOption() throws CalculationException {
        ForwardCurve forwardCurve = ForwardCurve.createForwardCurveFromForwards("forwardCurve", new double[]{0.0, 15.0}, new double[]{0.1, 0.1}, 0.5);
        LIBORModelMonteCarloSimulation lIBORModelMonteCarloSimulation = this.getLIBORModelMonteCarloSimulation(forwardCurve);
        double d = 5.0;
        double[] dArray = new double[]{5.0, 5.5, 6.0, 6.5, 7.0, 7.5};
        double[] dArray2 = new double[]{5.5, 6.0, 6.5, 7.0, 7.5, 8.0};
        double[] dArray3 = new double[]{5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0};
        double[] dArray4 = new double[]{0.5, 0.5, 0.5, 0.5, 0.5, 0.5};
        double d2 = 0.1;
        double[] dArray5 = new double[dArray4.length];
        Arrays.fill(dArray5, d2);
        SwaptionAnalyticApproximation swaptionAnalyticApproximation = new SwaptionAnalyticApproximation(d2, dArray3, SwaptionAnalyticApproximation.ValueUnit.INTEGRATEDVARIANCE);
        double d3 = swaptionAnalyticApproximation.getValue(lIBORModelMonteCarloSimulation);
        double d4 = Math.sqrt(d3 / d);
        CMSOption cMSOption = new CMSOption(d, dArray, dArray2, dArray4, d2);
        double d5 = cMSOption.getValue(lIBORModelMonteCarloSimulation);
        System.out.println("CMS Option with LIBOR Market Model..........................:\t" + formatterPercent.format(d5));
        double d6 = cMSOption.getValue(forwardCurve, d4);
        System.out.println("CMS Option with Hunt-Kennedy/Black-Scholes..................:\t" + formatterPercent.format(d6));
        TimeDiscretization timeDiscretization = new TimeDiscretization(dArray3);
        TimeDiscretization timeDiscretization2 = new TimeDiscretization(dArray3);
        double d7 = Swap.getForwardSwapRate(timeDiscretization, timeDiscretization2, (ForwardCurveInterface)forwardCurve);
        double d8 = SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)timeDiscretization, (ForwardCurveInterface)forwardCurve);
        double d9 = SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)new TimeDiscretization(dArray3[0], dArray3[1]), (ForwardCurveInterface)forwardCurve) / (dArray3[1] - dArray3[0]);
        double d10 = AnalyticFormulas.huntKennedyCMSAdjustedRate(d7, d4, d8, d, dArray3[dArray3.length - 1] - dArray3[0], d9);
        double d11 = AnalyticFormulas.blackModelSwaptionValue(d10, d4, d, d2, d9) * (dArray3[1] - dArray3[0]);
        System.out.println("CMS Option with Black-Scholes using Adjusted Forward Swapate:\t" + formatterPercent.format(d11));
        System.out.println("\nInfo:");
        System.out.println("Forward Swaprate............................................:\t" + formatterPercent.format(d7));
        System.out.println("Convexity Adjusted Forward Swaprate (Hunt-Kennedy)..........:\t" + formatterPercent.format(d10));
        Assert.assertEquals((String)"Value", (double)d5, (double)d6, (double)0.001);
        Caplet caplet = new Caplet(dArray[0], dArray4[0], d2);
        double d12 = caplet.getValue(lIBORModelMonteCarloSimulation);
        System.out.println("Caplet with LIBOR Market Model..............................:\t" + formatterPercent.format(d12));
        Swaption swaption = new Swaption(d, dArray, dArray2, dArray4, dArray5);
        double d13 = d9 / d8 * (dArray3[1] - dArray3[0]);
        double d14 = swaption.getValue(lIBORModelMonteCarloSimulation);
        System.out.println("Swaption with LIBOR Market Model............................:\t" + formatterPercent.format(d14 * d13));
        double d15 = swaption.getValue(forwardCurve, d4);
        System.out.println("Swaption with Black-Scholes.................................:\t" + formatterPercent.format(d15 * d13));
    }

    public LIBORModelMonteCarloSimulation getLIBORModelMonteCarloSimulation(ForwardCurveInterface forwardCurveInterface) throws CalculationException {
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, 15, 0.5);
        TimeDiscretization timeDiscretization2 = new TimeDiscretization(0.0, 30, 0.5);
        LIBORMarketModel lIBORMarketModel = new LIBORMarketModel(timeDiscretization2, forwardCurveInterface, new LIBORCovarianceModelFromVolatilityAndCorrelation(timeDiscretization, timeDiscretization2, new LIBORVolatilityModelTwoParameterExponentialForm(timeDiscretization, timeDiscretization2, 0.1, 0.0), new LIBORCorrelationModelExponentialDecay(timeDiscretization, timeDiscretization2, 5, 0.1, false)));
        BrownianMotion brownianMotion = new BrownianMotion(timeDiscretization, 5, 10000, 3141);
        ProcessEulerScheme processEulerScheme = new ProcessEulerScheme(brownianMotion);
        LIBORModelMonteCarloSimulation lIBORModelMonteCarloSimulation = new LIBORModelMonteCarloSimulation(lIBORMarketModel, processEulerScheme);
        return lIBORModelMonteCarloSimulation;
    }
}

