/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.rootfinder;

import net.finmath.rootfinder.RootFinder;

public class BisectionSearch
implements RootFinder {
    private final double[] points = new double[2];
    private final double[] values = new double[2];
    private double nextPoint;
    private int numberOfIterations = 0;
    private double accuracy = Double.MAX_VALUE;
    private boolean isDone = false;

    public BisectionSearch(double d, double d2) {
        this.points[0] = d;
        this.points[1] = d2;
        this.nextPoint = this.points[0];
        this.accuracy = this.points[1] - this.points[0];
    }

    @Override
    public double getBestPoint() {
        return (this.points[1] + this.points[0]) / 2.0;
    }

    @Override
    public double getNextPoint() {
        return this.nextPoint;
    }

    @Override
    public void setValue(double d) {
        if (this.numberOfIterations < 2) {
            this.values[this.numberOfIterations] = d;
            this.nextPoint = this.numberOfIterations < 1 ? this.points[this.numberOfIterations + 1] : (this.points[1] + this.points[0]) / 2.0;
        } else {
            if (this.values[1] * d > 0.0) {
                this.points[1] = this.nextPoint;
                this.values[1] = d;
            } else {
                this.points[0] = this.nextPoint;
                this.values[0] = d;
            }
            this.nextPoint = (this.points[1] + this.points[0]) / 2.0;
            if (this.points[1] - this.points[0] >= this.accuracy) {
                this.isDone = true;
            }
            this.accuracy = this.points[1] - this.points[0];
        }
        ++this.numberOfIterations;
    }

    @Override
    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    @Override
    public double getAccuracy() {
        return this.accuracy;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }
}

