/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.OptimizerFactoryInterface;
import net.finmath.optimizer.OptimizerInterface;
import net.finmath.optimizer.SolverException;

public class OptimizerFactoryLevenbergMarquardt
implements OptimizerFactoryInterface {
    private final int maxIterations;
    private final double errorTolerance;
    private final int maxThreads;

    public OptimizerFactoryLevenbergMarquardt(int n, double d, int n2) {
        this.maxIterations = n;
        this.errorTolerance = d;
        this.maxThreads = n2;
    }

    public OptimizerFactoryLevenbergMarquardt(int n, int n2) {
        this(n, 0.0, n2);
    }

    @Override
    public OptimizerInterface getOptimizer(OptimizerInterface.ObjectiveFunction objectiveFunction, double[] dArray) {
        return this.getOptimizer(objectiveFunction, dArray, null, null, null, null);
    }

    @Override
    public OptimizerInterface getOptimizer(OptimizerInterface.ObjectiveFunction objectiveFunction, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        return this.getOptimizer(objectiveFunction, dArray, dArray2, dArray3, null, dArray4);
    }

    @Override
    public OptimizerInterface getOptimizer(final OptimizerInterface.ObjectiveFunction objectiveFunction, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        return new LevenbergMarquardt(dArray, dArray5, this.maxIterations, this.maxThreads){
            private static final long serialVersionUID = -1628631567190057495L;

            @Override
            public void setValues(double[] dArray, double[] dArray2) throws SolverException {
                objectiveFunction.setValues(dArray, dArray2);
            }
        }.setErrorTolerance(this.errorTolerance);
    }
}

