/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.finmath.functions.LinearAlgebra;
import net.finmath.optimizer.OptimizerInterface;
import net.finmath.optimizer.SolverException;

public abstract class LevenbergMarquardt
implements Serializable,
Cloneable,
OptimizerInterface {
    private static final long serialVersionUID = 4560864869394838155L;
    private double[] initialParameters = null;
    private double[] parameterSteps = null;
    private double[] targetValues = null;
    private double[] weights = null;
    private int maxIteration = 100;
    private double lambda = 0.001;
    private double lambdaMultiplicator = 2.0;
    private double errorMeanSquaredTolerance = 0.0;
    private int iteration = 0;
    private double[] parameterTest = null;
    private double[] parameterIncrement = null;
    private double[] valueTest = null;
    private double[] parameterCurrent = null;
    private double[] valueCurrent = null;
    private double[][] derivativeCurrent = null;
    private double errorMeanSquaredCurrent = Double.POSITIVE_INFINITY;
    private double errorMeanSquaredChange = Double.POSITIVE_INFINITY;
    private boolean isParameterCurrentDerivativeValid = false;
    private double[][] hessianMatrix = null;
    private double[] beta = null;
    private int numberOfThreads = 1;
    private ExecutorService executor = null;
    private boolean executorShutdownWhenDone = true;
    private final Logger logger = Logger.getLogger("net.finmath");

    public static void main(String[] stringArray) throws SolverException, CloneNotSupportedException {
        LevenbergMarquardt levenbergMarquardt = new LevenbergMarquardt(){

            @Override
            public void setValues(double[] dArray, double[] dArray2) {
                dArray2[0] = dArray[0] * 0.0 + dArray[1];
                dArray2[1] = dArray[0] * 2.0 + dArray[1];
            }
        };
        levenbergMarquardt.setInitialParameters(new double[]{0.0, 0.0});
        levenbergMarquardt.setWeights(new double[]{1.0, 1.0});
        levenbergMarquardt.setMaxIteration(100);
        levenbergMarquardt.setTargetValues(new double[]{5.0, 10.0});
        levenbergMarquardt.run();
        double[] dArray = levenbergMarquardt.getBestFitParameters();
        System.out.println("The solver for problem 1 required " + levenbergMarquardt.getIterations() + " iterations. The best fit parameters are:");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println("\tparameter[" + i + "]: " + dArray[i]);
        }
        LevenbergMarquardt levenbergMarquardt2 = levenbergMarquardt.getCloneWithModifiedTargetValues(new double[]{5.1, 10.2}, new double[]{1.0, 1.0}, true);
        levenbergMarquardt2.run();
        double[] dArray2 = levenbergMarquardt2.getBestFitParameters();
        System.out.println("The solver for problem 2 required " + levenbergMarquardt2.getIterations() + " iterations. The best fit parameters are:");
        for (int i = 0; i < dArray2.length; ++i) {
            System.out.println("\tparameter[" + i + "]: " + dArray2[i]);
        }
    }

    public LevenbergMarquardt(double[] dArray, double[] dArray2, int n, ExecutorService executorService) {
        this.initialParameters = dArray;
        this.targetValues = dArray2;
        this.maxIteration = n;
        this.weights = new double[dArray2.length];
        Arrays.fill(this.weights, 1.0);
        this.executor = executorService;
        this.executorShutdownWhenDone = executorService == null;
        this.numberOfThreads = 1;
    }

    public LevenbergMarquardt(double[] dArray, double[] dArray2, int n, int n2) {
        this(dArray, dArray2, n, null);
        this.numberOfThreads = n2;
    }

    public LevenbergMarquardt(List<Number> list, List<Number> list2, int n, ExecutorService executorService) {
        this(LevenbergMarquardt.numberListToDoubleArray(list), LevenbergMarquardt.numberListToDoubleArray(list2), n, executorService);
    }

    public LevenbergMarquardt(List<Number> list, List<Number> list2, int n, int n2) {
        this(list, list2, n, null);
        this.numberOfThreads = n2;
    }

    public LevenbergMarquardt() {
    }

    private static double[] numberListToDoubleArray(List<Number> list) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = list.get(i).doubleValue();
        }
        return dArray;
    }

    public LevenbergMarquardt(int n) {
        this.numberOfThreads = n;
    }

    public LevenbergMarquardt setInitialParameters(double[] dArray) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.initialParameters = dArray;
        return this;
    }

    public LevenbergMarquardt setParameterSteps(double[] dArray) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.parameterSteps = dArray;
        return this;
    }

    public LevenbergMarquardt setTargetValues(double[] dArray) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.targetValues = dArray;
        return this;
    }

    public LevenbergMarquardt setMaxIteration(int n) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.maxIteration = n;
        return this;
    }

    public LevenbergMarquardt setWeights(double[] dArray) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.weights = dArray;
        return this;
    }

    public LevenbergMarquardt setErrorTolerance(double d) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.errorMeanSquaredTolerance = d * d;
        return this;
    }

    @Override
    public double[] getBestFitParameters() {
        return this.parameterCurrent;
    }

    @Override
    public double getRootMeanSquaredError() {
        return Math.sqrt(this.errorMeanSquaredCurrent);
    }

    public void setErrorMeanSquaredCurrent(double d) {
        this.errorMeanSquaredCurrent = d;
    }

    @Override
    public int getIterations() {
        return this.iteration;
    }

    public abstract void setValues(double[] var1, double[] var2) throws SolverException;

    public void setDerivatives(double[] dArray, double[][] dArray2) throws SolverException {
        int n;
        Vector<Future<double[]>> vector = new Vector<Future<double[]>>(this.parameterCurrent.length);
        for (n = 0; n < this.parameterCurrent.length; ++n) {
            Future<double[]> future;
            final double[] dArray3 = (double[])dArray.clone();
            final double[] dArray4 = dArray2[n];
            final int n2 = n;
            Callable<double[]> callable = new Callable<double[]>(){

                @Override
                public double[] call() throws SolverException {
                    double d = LevenbergMarquardt.this.parameterSteps != null ? LevenbergMarquardt.this.parameterSteps[n2] : (Math.abs(dArray3[n2]) + 1.0) * 1.0E-8;
                    int n = n2;
                    dArray3[n] = dArray3[n] + d;
                    try {
                        LevenbergMarquardt.this.setValues(dArray3, dArray4);
                    }
                    catch (Exception exception) {
                        Arrays.fill(dArray4, Double.NaN);
                    }
                    for (int i = 0; i < LevenbergMarquardt.this.valueCurrent.length; ++i) {
                        int n22 = i;
                        dArray4[n22] = dArray4[n22] - LevenbergMarquardt.this.valueCurrent[i];
                        int n3 = i;
                        dArray4[n3] = dArray4[n3] / d;
                        if (!Double.isNaN(dArray4[i])) continue;
                        dArray4[i] = 0.0;
                    }
                    return dArray4;
                }
            };
            if (this.executor != null) {
                future = this.executor.submit(callable);
                vector.add(n, future);
                continue;
            }
            future = new FutureTask<double[]>(callable);
            ((FutureTask)future).run();
            vector.add(n, future);
        }
        for (n = 0; n < this.parameterCurrent.length; ++n) {
            try {
                dArray2[n] = (double[])((Future)vector.get(n)).get();
                continue;
            }
            catch (InterruptedException interruptedException) {
                throw new SolverException(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new SolverException(executionException);
            }
        }
    }

    boolean done() {
        return this.iteration > this.maxIteration || this.errorMeanSquaredChange <= this.errorMeanSquaredTolerance || Double.isInfinite(this.lambda);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws SolverException {
        if (this.numberOfThreads > 1 && this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.numberOfThreads);
            this.executorShutdownWhenDone = true;
        }
        try {
            int n = this.initialParameters.length;
            int n2 = this.targetValues.length;
            this.parameterTest = (double[])this.initialParameters.clone();
            this.parameterIncrement = new double[n];
            this.parameterCurrent = new double[n];
            this.valueTest = new double[n2];
            this.valueCurrent = new double[n2];
            this.derivativeCurrent = new double[this.parameterCurrent.length][this.valueCurrent.length];
            this.hessianMatrix = new double[this.parameterCurrent.length][this.parameterCurrent.length];
            this.beta = new double[this.parameterCurrent.length];
            this.iteration = 0;
            while (true) {
                ++this.iteration;
                this.setValues(this.parameterTest, this.valueTest);
                double d = this.getMeanSquaredError(this.valueTest);
                if (d < this.errorMeanSquaredCurrent) {
                    this.errorMeanSquaredChange = this.errorMeanSquaredCurrent - d;
                    System.arraycopy(this.parameterTest, 0, this.parameterCurrent, 0, this.parameterCurrent.length);
                    System.arraycopy(this.valueTest, 0, this.valueCurrent, 0, this.valueCurrent.length);
                    this.errorMeanSquaredCurrent = d;
                    this.isParameterCurrentDerivativeValid = false;
                    this.lambda /= 1.3;
                    this.lambdaMultiplicator = 1.3;
                } else {
                    this.errorMeanSquaredChange = d - this.errorMeanSquaredCurrent;
                    this.lambda *= this.lambdaMultiplicator;
                    this.lambdaMultiplicator *= 1.3;
                }
                if (!this.done()) {
                    this.updateParameterTest();
                    if (!this.logger.isLoggable(Level.FINE)) continue;
                    String string = "Iteration: " + this.iteration + "\tLambda=" + this.lambda + "\tError Current:" + this.errorMeanSquaredCurrent + "\tError Change:" + this.errorMeanSquaredChange + "\t";
                    for (int i = 0; i < this.parameterCurrent.length; ++i) {
                        string = string + "[" + i + "] = " + this.parameterCurrent[i] + "\t";
                    }
                    this.logger.fine(string);
                    continue;
                }
                break;
            }
        }
        finally {
            if (this.executor != null && this.executorShutdownWhenDone) {
                this.executor.shutdown();
                this.executor = null;
            }
        }
    }

    public double getMeanSquaredError(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - this.targetValues[i];
            d += this.weights[i] * d2 * d2;
        }
        return d / (double)dArray.length;
    }

    private void updateParameterTest() throws SolverException {
        if (!this.isParameterCurrentDerivativeValid) {
            this.setDerivatives(this.parameterCurrent, this.derivativeCurrent);
            this.isParameterCurrentDerivativeValid = true;
        }
        boolean bl = true;
        while (bl) {
            int n;
            int n2;
            bl = false;
            for (n2 = 0; n2 < this.parameterCurrent.length; ++n2) {
                for (int i = n2; i < this.parameterCurrent.length; ++i) {
                    double d = 0.0;
                    for (n = 0; n < this.valueCurrent.length; ++n) {
                        d += this.weights[n] * this.derivativeCurrent[n2][n] * this.derivativeCurrent[i][n];
                    }
                    if (n2 == i) {
                        d = d == 0.0 ? 1.0 : (d *= 1.0 + this.lambda);
                    }
                    this.hessianMatrix[n2][i] = d;
                    this.hessianMatrix[i][n2] = d;
                }
            }
            for (n2 = 0; n2 < this.parameterCurrent.length; ++n2) {
                double d = 0.0;
                double[] dArray = this.derivativeCurrent[n2];
                for (n = 0; n < this.valueCurrent.length; ++n) {
                    d += this.weights[n] * (this.targetValues[n] - this.valueCurrent[n]) * dArray[n];
                }
                this.beta[n2] = d;
            }
            try {
                this.parameterIncrement = LinearAlgebra.solveLinearEquationSymmetric(this.hessianMatrix, this.beta);
            }
            catch (Exception exception) {
                bl = true;
                this.lambda *= 16.0;
            }
        }
        for (int i = 0; i < this.parameterCurrent.length; ++i) {
            this.parameterTest[i] = this.parameterCurrent[i] + this.parameterIncrement[i];
        }
    }

    public LevenbergMarquardt clone() throws CloneNotSupportedException {
        LevenbergMarquardt levenbergMarquardt = (LevenbergMarquardt)super.clone();
        levenbergMarquardt.isParameterCurrentDerivativeValid = false;
        levenbergMarquardt.iteration = 0;
        levenbergMarquardt.errorMeanSquaredCurrent = Double.POSITIVE_INFINITY;
        levenbergMarquardt.errorMeanSquaredChange = Double.POSITIVE_INFINITY;
        return levenbergMarquardt;
    }

    public LevenbergMarquardt getCloneWithModifiedTargetValues(double[] dArray, double[] dArray2, boolean bl) throws CloneNotSupportedException {
        LevenbergMarquardt levenbergMarquardt = this.clone();
        levenbergMarquardt.targetValues = (double[])dArray.clone();
        levenbergMarquardt.weights = (double[])dArray2.clone();
        if (bl && this.done()) {
            levenbergMarquardt.initialParameters = this.getBestFitParameters();
        }
        return levenbergMarquardt;
    }

    public LevenbergMarquardt getCloneWithModifiedTargetValues(List<Number> list, List<Number> list2, boolean bl) throws CloneNotSupportedException {
        LevenbergMarquardt levenbergMarquardt = this.clone();
        levenbergMarquardt.targetValues = LevenbergMarquardt.numberListToDoubleArray(list);
        levenbergMarquardt.weights = LevenbergMarquardt.numberListToDoubleArray(list2);
        if (bl && this.done()) {
            levenbergMarquardt.initialParameters = this.getBestFitParameters();
        }
        return levenbergMarquardt;
    }
}

