/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

public class GoldenSectionSearch {
    static final double goldenSectionRatio = (3.0 - Math.sqrt(5.0)) / 2.0;
    private final double[] points = new double[3];
    private final double[] values = new double[3];
    private double nextPoint;
    private boolean expectingValue = false;
    private int numberOfIterations = 0;
    private double accuracy;
    private boolean isDone = false;

    public static void main(String[] stringArray) {
        System.out.println("Test of GoldenSectionSearch Class.\n");
        System.out.println("1. Find minimum of f(x) = (x - 0.656) * (x - 0.656):");
        GoldenSectionSearch goldenSectionSearch = new GoldenSectionSearch(-1.0, 5.0);
        while (goldenSectionSearch.getAccuracy() > 1.0E-11 && !goldenSectionSearch.isDone()) {
            double d = goldenSectionSearch.getNextPoint();
            double d2 = (d - 0.656) * (d - 0.656);
            goldenSectionSearch.setValue(d2);
        }
        System.out.println("Result....: " + goldenSectionSearch.getBestPoint());
        System.out.println("Solution..: 0.656");
        System.out.println("Iterations: " + goldenSectionSearch.getNumberOfIterations() + "\n");
        System.out.println("2. Find minimum of f(x) = cos(x) on [0.0,6.0]:");
        GoldenSectionSearch goldenSectionSearch2 = new GoldenSectionSearch(0.0, 6.0);
        while (goldenSectionSearch2.getAccuracy() > 1.0E-11 && !goldenSectionSearch2.isDone()) {
            double d = goldenSectionSearch2.getNextPoint();
            double d3 = Math.cos(d);
            goldenSectionSearch2.setValue(d3);
        }
        System.out.println("Result....: " + goldenSectionSearch2.getBestPoint());
        System.out.println("Solution..: 3.141592653589793 (Pi)");
        System.out.println("Iterations: " + goldenSectionSearch2.getNumberOfIterations() + "\n");
    }

    public GoldenSectionSearch(double d, double d2) {
        this.points[0] = d;
        this.points[1] = GoldenSectionSearch.getGoldenSection(d, d2);
        this.points[2] = d2;
        this.nextPoint = this.points[0];
        this.accuracy = this.points[2] - this.points[0];
    }

    public double getBestPoint() {
        return this.points[1];
    }

    public double getNextPoint() {
        this.expectingValue = true;
        return this.nextPoint;
    }

    public void setValue(double d) {
        if (!this.expectingValue) {
            throw new RuntimeException("Call to setValue() perfomed without prior getNextPoint() call (e.g. call performed twice).");
        }
        if (this.numberOfIterations < 3) {
            this.values[this.numberOfIterations] = d;
            this.nextPoint = this.numberOfIterations < 2 ? this.points[this.numberOfIterations + 1] : (this.points[1] - this.points[0] > this.points[2] - this.points[1] ? GoldenSectionSearch.getGoldenSection(this.points[0], this.points[1]) : GoldenSectionSearch.getGoldenSection(this.points[1], this.points[2]));
        } else {
            if (this.points[1] - this.points[0] > this.points[2] - this.points[1]) {
                if (d < this.values[1]) {
                    this.points[2] = this.points[1];
                    this.values[2] = this.values[1];
                    this.points[1] = this.nextPoint;
                    this.values[1] = d;
                } else {
                    this.points[0] = this.nextPoint;
                    this.values[0] = d;
                }
            } else if (d < this.values[1]) {
                this.points[0] = this.points[1];
                this.values[0] = this.values[1];
                this.points[1] = this.nextPoint;
                this.values[1] = d;
            } else {
                this.points[2] = this.nextPoint;
                this.values[2] = d;
            }
            this.nextPoint = this.points[1] - this.points[0] > this.points[2] - this.points[1] ? GoldenSectionSearch.getGoldenSection(this.points[0], this.points[1]) : GoldenSectionSearch.getGoldenSection(this.points[1], this.points[2]);
            if (this.points[2] - this.points[0] >= this.accuracy) {
                this.isDone = true;
            }
            this.accuracy = this.points[2] - this.points[0];
        }
        ++this.numberOfIterations;
        this.expectingValue = false;
    }

    public void optimize() {
        while (!this.isDone()) {
            double d = this.getNextPoint();
            double d2 = this.value(d);
            this.setValue(d2);
        }
    }

    public double value(double d) {
        throw new RuntimeException("Objective function not overwritten.");
    }

    static double getGoldenSection(double d, double d2) {
        return goldenSectionRatio * d + (1.0 - goldenSectionRatio) * d2;
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public boolean isDone() {
        return this.isDone;
    }
}

