/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.model;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.model.AbstractModelInterface;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public abstract class AbstractModel
implements AbstractModelInterface {
    private AbstractProcessInterface process;

    public RandomVariableInterface[] getInitialValue() {
        RandomVariableInterface[] randomVariableInterfaceArray = this.getInitialState();
        RandomVariableInterface[] randomVariableInterfaceArray2 = new RandomVariableInterface[randomVariableInterfaceArray.length];
        for (int i = 0; i < randomVariableInterfaceArray2.length; ++i) {
            randomVariableInterfaceArray2[i] = this.applyStateSpaceTransform(i, randomVariableInterfaceArray[i]);
        }
        return randomVariableInterfaceArray2;
    }

    @Override
    public void setProcess(AbstractProcessInterface abstractProcessInterface) {
        this.process = abstractProcessInterface;
    }

    @Override
    public AbstractProcessInterface getProcess() {
        return this.process;
    }

    @Override
    public int getNumberOfFactors() {
        return this.process.getNumberOfFactors();
    }

    public RandomVariableInterface getProcessValue(int n, int n2) throws CalculationException {
        return this.process.getProcessValue(n, n2);
    }

    public RandomVariableInterface getMonteCarloWeights(int n) throws CalculationException {
        return this.process.getMonteCarloWeights(n);
    }

    @Override
    public final TimeDiscretizationInterface getTimeDiscretization() {
        return this.process.getTimeDiscretization();
    }

    public final double getTime(int n) {
        return this.process.getTime(n);
    }

    public final int getTimeIndex(double d) {
        return this.process.getTimeIndex(d);
    }
}

