/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class LinearCombinationIndex
extends AbstractIndex {
    private static final long serialVersionUID = -8181742829635380940L;
    private AbstractProductComponent index1;
    private AbstractProductComponent index2;
    private double scaling1;
    private double scaling2;

    public LinearCombinationIndex(double d, AbstractProductComponent abstractProductComponent, double d2, AbstractProductComponent abstractProductComponent2) {
        this.scaling1 = d;
        this.index1 = abstractProductComponent;
        this.scaling2 = d2;
        this.index2 = abstractProductComponent2;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        return this.index1.getValue(d, lIBORModelMonteCarloSimulationInterface).mult(this.scaling1).addProduct(this.index2.getValue(d, lIBORModelMonteCarloSimulationInterface), this.scaling2);
    }

    public AbstractProductComponent getIndex1() {
        return this.index1;
    }

    public AbstractProductComponent getIndex2() {
        return this.index2;
    }

    public double getScaling1() {
        return this.scaling1;
    }

    public double getScaling2() {
        return this.scaling2;
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> set = this.index1.queryUnderlyings();
        Set<String> set2 = this.index2.queryUnderlyings();
        if (set2 != null) {
            if (set != null) {
                set.addAll(set2);
            } else {
                set = set2;
            }
        }
        return set;
    }

    @Override
    public String toString() {
        return "LinearCombinationIndex [index1=" + this.index1 + ", index2=" + this.index2 + ", scaling1=" + this.scaling1 + ", scaling2=" + this.scaling2 + ", toString()=" + super.toString() + "]";
    }
}

