/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Calendar;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class DateIndex
extends AbstractIndex {
    private static final long serialVersionUID = 7457336500162149869L;
    private DateIndexType dateIndexType;

    public DateIndex(String string, String string2, DateIndexType dateIndexType) {
        super(string, string2);
        this.dateIndexType = dateIndexType;
    }

    public DateIndex(String string, DateIndexType dateIndexType) {
        super(string);
        this.dateIndexType = dateIndexType;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        Calendar calendar = (Calendar)lIBORModelMonteCarloSimulationInterface.getModel().getForwardRateCurve().getReferenceDate().clone();
        calendar.add(6, (int)Math.round(d * 365.0));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        double d2 = 0.0;
        switch (this.dateIndexType) {
            case DAY: {
                d2 = calendar.get(5);
                break;
            }
            case MONTH: {
                d2 = calendar.get(2);
                break;
            }
            case YEAR: {
                d2 = calendar.get(1);
                break;
            }
            case NUMBER_OF_DAYS_IN_MONTH: {
                d2 = calendar.getActualMaximum(5);
            }
        }
        return lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(d2);
    }

    @Override
    public Set<String> queryUnderlyings() {
        return null;
    }

    public static enum DateIndexType {
        DAY,
        MONTH,
        YEAR,
        NUMBER_OF_DAYS_IN_MONTH;

    }
}

