/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class CappedFlooredIndex
extends AbstractIndex {
    private static final long serialVersionUID = 7835825574794506180L;
    private final AbstractIndex index;
    private final AbstractIndex cap;
    private final AbstractIndex floor;

    public CappedFlooredIndex(AbstractIndex abstractIndex, AbstractIndex abstractIndex2, AbstractIndex abstractIndex3) {
        this.index = abstractIndex;
        this.cap = abstractIndex2;
        this.floor = abstractIndex3;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = this.index.getValue(d, lIBORModelMonteCarloSimulationInterface);
        if (this.floor != null) {
            randomVariableInterface = randomVariableInterface.floor(this.floor.getValue(d, lIBORModelMonteCarloSimulationInterface));
        }
        if (this.cap != null) {
            randomVariableInterface = randomVariableInterface.cap(this.cap.getValue(d, lIBORModelMonteCarloSimulationInterface));
        }
        return randomVariableInterface;
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> set;
        Set<String> set2;
        Set<String> set3 = this.index != null ? this.index.queryUnderlyings() : null;
        Set<String> set4 = set2 = this.cap != null ? this.cap.queryUnderlyings() : null;
        if (set2 != null) {
            if (set3 != null) {
                set3.addAll(set2);
            } else {
                set3 = set2;
            }
        }
        Set<String> set5 = set = this.floor != null ? this.floor.queryUnderlyings() : null;
        if (set != null) {
            if (set3 != null) {
                set3.addAll(set);
            } else {
                set3 = set;
            }
        }
        return set3;
    }

    @Override
    public String toString() {
        return "CappedFlooredIndex [index=" + this.index + ", cap=" + this.cap + ", floor=" + this.floor + ", toString()=" + super.toString() + "]";
    }
}

