/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.HashSet;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class AnalyticModelForwardCurveIndex
extends AbstractIndex {
    private static final long serialVersionUID = 1L;
    private final String curveName;
    private final double fixingOffet;
    private final double paymentOffset;

    public AnalyticModelForwardCurveIndex(String string, String string2, double d, double d2) {
        super(string);
        this.curveName = string2;
        this.fixingOffet = d;
        this.paymentOffset = d2;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        AnalyticModelInterface analyticModelInterface = lIBORModelMonteCarloSimulationInterface.getModel().getAnalyticModel();
        if (analyticModelInterface == null) {
            throw new IllegalArgumentException("Provided model does not carry an associated analytic model.");
        }
        ForwardCurveInterface forwardCurveInterface = analyticModelInterface.getForwardCurve(this.curveName);
        if (forwardCurveInterface == null) {
            throw new IllegalArgumentException("Associated analytic model does not carry a curve of the name " + this.curveName + ".");
        }
        double d2 = forwardCurveInterface.getForward(analyticModelInterface, d + this.fixingOffet, this.paymentOffset);
        return lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(d2);
    }

    public double getPeriodStartOffset() {
        return this.fixingOffet;
    }

    @Override
    public Set<String> queryUnderlyings() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.getName());
        return hashSet;
    }

    @Override
    public String toString() {
        return "AnalyticModelIndex [curveName=" + this.curveName + ", fixingOffet=" + this.fixingOffet + "]";
    }
}

