/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Calendar;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.daycount.DayCountConventionInterface;

public class AccruedInterest
extends AbstractIndex {
    private static final long serialVersionUID = 147619920344514766L;
    private final Calendar referenceDate;
    private final Calendar periodStartDate;
    private final Calendar periodEndDate;
    private final AbstractIndex index;
    private final Double indexFixingTime;
    private final DayCountConventionInterface daycountConvention;
    private final boolean isNegativeAccruedInterest;

    public AccruedInterest(String string, String string2, Calendar calendar, Calendar calendar2, Calendar calendar3, AbstractIndex abstractIndex, Double d, DayCountConventionInterface dayCountConventionInterface, boolean bl) {
        super(string, string2);
        this.referenceDate = calendar;
        this.periodStartDate = calendar2;
        this.periodEndDate = calendar3;
        this.index = abstractIndex;
        this.indexFixingTime = d;
        this.daycountConvention = dayCountConventionInterface;
        this.isNegativeAccruedInterest = bl;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        double d2 = this.daycountConvention.getDaycountFraction(this.periodStartDate, this.getModelDate(d));
        double d3 = this.daycountConvention.getDaycountFraction(this.periodStartDate, this.periodEndDate);
        d2 = Math.min(Math.max(d2, 0.0), d3);
        if (this.isNegativeAccruedInterest) {
            d2 = d3 - d2;
        }
        return this.index.getValue((double)this.indexFixingTime, lIBORModelMonteCarloSimulationInterface).mult(d2);
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.index.queryUnderlyings();
    }

    private Calendar getModelDate(double d) {
        Calendar calendar = (Calendar)this.referenceDate.clone();
        calendar.add(6, (int)(d * 365.0));
        return calendar;
    }
}

