/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import net.finmath.concurrency.FutureWrapper;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.AbstractMonteCarloProduct;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class ProductCollection
extends AbstractProductComponent {
    private static final long serialVersionUID = -3058874897795789705L;
    private Collection<AbstractProductComponent> products;

    public ProductCollection(AbstractProductComponent ... abstractProductComponentArray) {
        this(Arrays.asList(abstractProductComponentArray));
    }

    public ProductCollection(Collection<AbstractProductComponent> collection) {
        this.products = collection;
    }

    @Override
    public String getCurrency() {
        return this.products.iterator().next().getCurrency();
    }

    public Collection<AbstractProductComponent> getProducts() {
        return Collections.unmodifiableCollection(this.products);
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> set = null;
        for (AbstractProductComponent abstractProductComponent : this.products) {
            Set<String> set2 = abstractProductComponent.queryUnderlyings();
            if (set2 == null) continue;
            if (set == null) {
                set = set2;
                continue;
            }
            set.addAll(set2);
        }
        return set;
    }

    @Override
    public RandomVariableInterface getValue(final double d, final LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        ArrayList<Future> arrayList = new ArrayList<Future>();
        for (final AbstractMonteCarloProduct object : this.products) {
            Future future;
            try {
                future = executor.submit(new Callable<RandomVariableInterface>(){

                    @Override
                    public RandomVariableInterface call() throws CalculationException {
                        return object.getValue(d, lIBORModelMonteCarloSimulationInterface);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                future = new FutureWrapper<RandomVariableInterface>(object.getValue(d, lIBORModelMonteCarloSimulationInterface));
            }
            arrayList.add(future);
        }
        Object object = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        try {
            for (Future future : arrayList) {
                object = object.add((RandomVariableInterface)future.get());
            }
        }
        catch (InterruptedException executionException) {
            throw executionException.getCause() instanceof CalculationException ? (CalculationException)executionException.getCause() : new CalculationException(executionException.getCause());
        }
        catch (ExecutionException executionException) {
            if (CalculationException.class.isInstance(executionException.getCause())) {
                throw (CalculationException)executionException.getCause();
            }
            if (RuntimeException.class.isInstance(executionException.getCause())) {
                throw (RuntimeException)executionException.getCause();
            }
            throw new CalculationException(executionException.getCause());
        }
        return object;
    }

    @Override
    public String toString() {
        return "ProductCollection [products=" + this.products + "]";
    }
}

