/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractNotional;
import net.finmath.montecarlo.interestrate.products.components.AbstractPeriod;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class Period
extends AbstractPeriod {
    private static final long serialVersionUID = -7107623461781510475L;
    private final boolean couponFlow;
    private final boolean notionalFlow;
    private final boolean payer;
    private final boolean isExcludeAccruedInterest;

    public Period(double d, double d2, double d3, double d4, AbstractNotional abstractNotional, AbstractProductComponent abstractProductComponent, double d5, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(d, d2, d3, d4, abstractNotional, abstractProductComponent, d5);
        this.couponFlow = bl;
        this.notionalFlow = bl2;
        this.payer = bl3;
        this.isExcludeAccruedInterest = bl4;
    }

    public Period(double d, double d2, double d3, double d4, AbstractNotional abstractNotional, AbstractProductComponent abstractProductComponent, double d5, boolean bl, boolean bl2, boolean bl3) {
        this(d, d2, d3, d4, abstractNotional, abstractProductComponent, d5, bl, bl2, bl3, false);
    }

    public Period(double d, double d2, double d3, double d4, AbstractNotional abstractNotional, AbstractProductComponent abstractProductComponent, boolean bl, boolean bl2, boolean bl3) {
        this(d, d2, d3, d4, abstractNotional, abstractProductComponent, d2 - d, bl, bl2, bl3);
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface;
        if (d >= this.getPaymentDate()) {
            return new RandomVariable(0.0);
        }
        RandomVariableInterface randomVariableInterface2 = this.getNotional().getNotionalAtPeriodStart(this, lIBORModelMonteCarloSimulationInterface);
        RandomVariableInterface randomVariableInterface3 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface4 = lIBORModelMonteCarloSimulationInterface.getNumeraire(this.getPaymentDate());
        if (this.couponFlow) {
            randomVariableInterface = this.getCoupon(lIBORModelMonteCarloSimulationInterface);
            randomVariableInterface = randomVariableInterface.mult(randomVariableInterface2);
            randomVariableInterface = randomVariableInterface.div(randomVariableInterface4);
            if (this.isExcludeAccruedInterest && d >= this.getPeriodStart() && d < this.getPeriodEnd()) {
                double d2 = (this.getPeriodEnd() - d) / (this.getPeriodEnd() - this.getPeriodStart());
                randomVariableInterface = randomVariableInterface.mult(d2);
            }
        } else {
            randomVariableInterface = new RandomVariable(0.0, 0.0);
        }
        if (this.notionalFlow) {
            RandomVariableInterface randomVariableInterface5;
            RandomVariableInterface randomVariableInterface6 = this.getNotional().getNotionalAtPeriodEnd(this, lIBORModelMonteCarloSimulationInterface);
            if (this.getPeriodStart() > d) {
                randomVariableInterface5 = lIBORModelMonteCarloSimulationInterface.getNumeraire(this.getPeriodStart());
                randomVariableInterface = randomVariableInterface.subRatio(randomVariableInterface2, randomVariableInterface5);
            }
            if (this.getPeriodEnd() > d) {
                randomVariableInterface5 = lIBORModelMonteCarloSimulationInterface.getNumeraire(this.getPeriodEnd());
                randomVariableInterface = randomVariableInterface.addRatio(randomVariableInterface6, randomVariableInterface5);
            }
        }
        if (this.payer) {
            randomVariableInterface = randomVariableInterface.mult(-1.0);
        }
        randomVariableInterface = randomVariableInterface.mult(randomVariableInterface3);
        return randomVariableInterface;
    }

    @Override
    public RandomVariableInterface getCoupon(LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = this.getIndex().getValue(this.getFixingDate(), lIBORModelMonteCarloSimulationInterface);
        double d = this.getDaycountFraction();
        randomVariableInterface = randomVariableInterface.mult(d);
        return randomVariableInterface;
    }

    @Override
    public String toString() {
        return "Period [couponFlow=" + this.couponFlow + ", notionalFlow=" + this.notionalFlow + ", payer=" + this.payer + ", toString()=" + super.toString() + "]";
    }
}

