/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class Cashflow
extends AbstractProductComponent {
    private static final long serialVersionUID = 2336470863786839896L;
    private final double flowAmount;
    private final double flowDate;
    private final boolean isPayer;

    public Cashflow(String string, double d, double d2, boolean bl) {
        super(string);
        this.flowAmount = d;
        this.flowDate = d2;
        this.isPayer = bl;
    }

    public Cashflow(double d, double d2, boolean bl) {
        this(null, d, d2, bl);
    }

    @Override
    public Set<String> queryUnderlyings() {
        return null;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        if (d > this.flowDate) {
            return lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        }
        RandomVariableInterface randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(this.flowAmount);
        if (this.isPayer) {
            randomVariableInterface = randomVariableInterface.mult(-1.0);
        }
        if (this.flowDate != d) {
            RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getNumeraire(this.flowDate);
            RandomVariableInterface randomVariableInterface3 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
            randomVariableInterface = randomVariableInterface.div(randomVariableInterface2).mult(randomVariableInterface3);
        }
        return randomVariableInterface;
    }

    @Override
    public String toString() {
        return "Cashflow [flowAmount=" + this.flowAmount + ", flowDate=" + this.flowDate + ", isPayer=" + this.isPayer + ", toString()=" + super.toString() + "]";
    }
}

