/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.HashMap;
import java.util.Map;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class SwaptionSingleCurveAnalyticApproximation
extends AbstractLIBORMonteCarloProduct {
    private final double swaprate;
    private final double[] swapTenor;
    private final ValueUnit valueUnit;

    public SwaptionSingleCurveAnalyticApproximation(double d, TimeDiscretizationInterface timeDiscretizationInterface) {
        this(d, timeDiscretizationInterface.getAsDoubleArray(), ValueUnit.VALUE);
    }

    public SwaptionSingleCurveAnalyticApproximation(double d, double[] dArray, ValueUnit valueUnit) {
        this.swaprate = d;
        this.swapTenor = dArray;
        this.valueUnit = valueUnit;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) {
        return this.getValues(d, lIBORModelMonteCarloSimulationInterface.getModel());
    }

    public RandomVariableInterface getValues(double d, LIBORMarketModelInterface lIBORMarketModelInterface) {
        if (d > 0.0) {
            throw new RuntimeException("Forward start evaluation currently not supported.");
        }
        double d2 = this.swapTenor[0];
        double d3 = this.swapTenor[this.swapTenor.length - 1];
        int n = lIBORMarketModelInterface.getLiborPeriodIndex(d2);
        int n2 = lIBORMarketModelInterface.getLiborPeriodIndex(d3);
        int n3 = lIBORMarketModelInterface.getCovarianceModel().getTimeDiscretization().getTimeIndex(d2) - 1;
        Map<String, double[]> map = SwaptionSingleCurveAnalyticApproximation.getLogSwaprateDerivative(lIBORMarketModelInterface.getLiborPeriodDiscretization(), lIBORMarketModelInterface.getForwardRateCurve(), this.swapTenor);
        double[] dArray = map.get("values");
        double[] dArray2 = map.get("discountFactors");
        double[] dArray3 = map.get("swapAnnuities");
        double[][] dArray4 = lIBORMarketModelInterface.getIntegratedLIBORCovariance()[n3];
        double d4 = 0.0;
        for (int i = n; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                d4 += 2.0 * dArray[i - n] * dArray[j - n] * dArray4[i][j];
            }
            d4 += dArray[i - n] * dArray[i - n] * dArray4[i][i];
        }
        if (this.valueUnit == ValueUnit.INTEGRATEDVARIANCE) {
            return new RandomVariable(d, d4);
        }
        double d5 = Math.sqrt(d4 / d2);
        if (this.valueUnit == ValueUnit.VOLATILITY) {
            return new RandomVariable(d, d5);
        }
        double d6 = dArray3[0];
        double d7 = (dArray2[0] - dArray2[n2 - n]) / d6;
        double d8 = d2;
        double d9 = AnalyticFormulas.blackModelSwaptionValue(d7, d5, d8, this.swaprate, d6);
        return new RandomVariable(d, d9);
    }

    public static Map<String, double[]> getLogSwaprateDerivative(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, double[] dArray) {
        double d;
        double d2;
        int n;
        double d3 = dArray[0];
        double d4 = dArray[dArray.length - 1];
        int n2 = timeDiscretizationInterface.getTimeIndex(d3);
        int n3 = timeDiscretizationInterface.getTimeIndex(d4);
        double[] dArray2 = new double[n3 - n2 + 1];
        double[] dArray3 = new double[n3 - n2 + 1];
        dArray3[0] = 1.0;
        for (n = 0; n < n2; ++n) {
            d2 = forwardCurveInterface.getForward(null, timeDiscretizationInterface.getTime(n));
            d = timeDiscretizationInterface.getTimeStep(n);
            dArray3[0] = dArray3[0] / (1.0 + d2 * d);
        }
        for (n = n2; n < n3; ++n) {
            d2 = forwardCurveInterface.getForward(null, timeDiscretizationInterface.getTime(n));
            d = timeDiscretizationInterface.getTimeStep(n);
            dArray2[n - n2] = d2;
            dArray3[n - n2 + 1] = dArray3[n - n2] / (1.0 + d2 * d);
        }
        double[] dArray4 = new double[dArray.length - 1];
        d2 = 0.0;
        for (int i = dArray.length - 2; i >= 0; --i) {
            int n4 = timeDiscretizationInterface.getTimeIndex(dArray[i + 1]);
            dArray4[i] = d2 += dArray3[n4 - n2] * (dArray[i + 1] - dArray[i]);
        }
        double d5 = dArray3[n3 - n2] / (dArray3[0] - dArray3[n3 - n2]);
        double[] dArray5 = new double[n3 - n2];
        int n5 = 0;
        for (int i = n2; i < n3; ++i) {
            if (timeDiscretizationInterface.getTime(i) >= dArray[n5 + 1]) {
                ++n5;
            }
            dArray5[i - n2] = (d5 + dArray4[n5] / d2) * (1.0 - dArray3[i - n2 + 1] / dArray3[i - n2]);
        }
        HashMap<String, double[]> hashMap = new HashMap<String, double[]>();
        hashMap.put("values", dArray5);
        hashMap.put("discountFactors", dArray3);
        hashMap.put("swapAnnuities", dArray4);
        return hashMap;
    }

    public static double[][][] getIntegratedLIBORCovariance(LIBORMarketModel lIBORMarketModel) {
        return lIBORMarketModel.getIntegratedLIBORCovariance();
    }

    public static enum ValueUnit {
        VALUE,
        INTEGRATEDVARIANCE,
        VOLATILITY;

    }
}

