/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.Swaption;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class SwaptionSimple
extends AbstractLIBORMonteCarloProduct {
    private final TimeDiscretizationInterface tenor;
    private final double swaprate;
    private final Swaption swaption;
    private final ValueUnit valueUnit;

    public SwaptionSimple(double d, TimeDiscretizationInterface timeDiscretizationInterface) {
        this(d, timeDiscretizationInterface.getAsDoubleArray(), ValueUnit.VALUE);
    }

    public SwaptionSimple(double d, double[] dArray, ValueUnit valueUnit) {
        this.tenor = new TimeDiscretization(dArray);
        this.swaprate = d;
        this.swaption = new Swaption(dArray[0], this.tenor, d);
        this.valueUnit = valueUnit;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        ForwardCurveInterface forwardCurveInterface;
        RandomVariableInterface randomVariableInterface = this.swaption.getValue(d, lIBORModelMonteCarloSimulationInterface);
        if (this.valueUnit == ValueUnit.VALUE) {
            return randomVariableInterface;
        }
        ForwardCurveInterface forwardCurveInterface2 = forwardCurveInterface = lIBORModelMonteCarloSimulationInterface.getModel().getForwardRateCurve();
        double d2 = Swap.getForwardSwapRate(this.tenor, this.tenor, forwardCurveInterface);
        double d3 = this.tenor.getTime(0);
        double d4 = this.swaprate;
        double d5 = SwapAnnuity.getSwapAnnuity(this.tenor, forwardCurveInterface2);
        double d6 = AnalyticFormulas.blackScholesOptionImpliedVolatility(d2, d3, d4, d5, randomVariableInterface.getAverage());
        if (this.valueUnit == ValueUnit.VOLATILITY) {
            return lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(d6);
        }
        if (this.valueUnit == ValueUnit.INTEGRATEDVARIANCE) {
            return lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(d6 * d6 * d3);
        }
        throw new UnsupportedOperationException("Provided valueUnit not implemented.");
    }

    @Override
    public String toString() {
        return "SwaptionSimple [tenor=" + this.tenor + ", swaprate=" + this.swaprate + ", valueUnit=" + (Object)((Object)this.valueUnit) + "]";
    }

    public static enum ValueUnit {
        VALUE,
        INTEGRATEDVARIANCE,
        VOLATILITY;

    }
}

