/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModelExponentialDecay;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCovarianceModelFromVolatilityAndCorrelation;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModelFromGivenMatrix;
import net.finmath.montecarlo.interestrate.products.Swaption;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximation;
import net.finmath.montecarlo.interestrate.products.SwaptionSingleCurveAnalyticApproximation;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;
import org.junit.Assert;
import org.junit.Test;

public class SwaptionAnalyticApproximationTest {
    private static DecimalFormat formatterMaturity = new DecimalFormat("00.00", new DecimalFormatSymbols(Locale.ENGLISH));
    private static DecimalFormat formatterValue = new DecimalFormat(" ##0.000%;-##0.000%", new DecimalFormatSymbols(Locale.ENGLISH));
    private static DecimalFormat formatterDeviation = new DecimalFormat(" 0.00000E00;-0.00000E00", new DecimalFormatSymbols(Locale.ENGLISH));
    private final int numberOfPaths = 20000;
    private final int numberOfFactors = 5;
    private final double correlationDecayParam = 0.04;

    @Test
    public void testSingleCurveModel() throws CalculationException {
        System.out.println("Runnning tests with a single curve LIBOR Market Model");
        LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface = SwaptionAnalyticApproximationTest.createSingleCurveLIBORMarketModel(20000, 5, 0.04);
        this.testModel(lIBORModelMonteCarloSimulationInterface, false);
    }

    @Test
    public void testMultiCurveModel() throws CalculationException {
        System.out.println("Runnning tests with a multi curve LIBOR Market Model");
        LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface = SwaptionAnalyticApproximationTest.createMultiCurveLIBORMarketModel(20000, 5, 0.04);
        this.testModel(lIBORModelMonteCarloSimulationInterface, true);
    }

    public void testModel(LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface, boolean bl) throws CalculationException {
        System.out.println("Swaption prices (isMultiCurve = " + bl + "):\n");
        System.out.println("Maturity      Simulation (MC)   Analytic (SC)   Analytic (MC)    Deviation (AMC-S)      Deviation (AMC-ASC)");
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 1; i <= lIBORModelMonteCarloSimulationInterface.getNumberOfLibors() - 10; ++i) {
            double d3 = lIBORModelMonteCarloSimulationInterface.getLiborPeriod(i);
            System.out.print(formatterMaturity.format(d3) + "          ");
            int n = 5;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n + 1];
            double d4 = 0.5;
            for (int j = 0; j < n; ++j) {
                dArray[j] = d3 + (double)j * d4;
                dArray2[j] = d3 + (double)(j + 1) * d4;
                dArray3[j] = d3 + (double)j * d4;
            }
            dArray3[n] = d3 + (double)n * d4;
            double d5 = 0.05;
            double[] dArray4 = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray4[j] = d5;
            }
            Swaption swaption = new Swaption(d3, dArray, dArray2, dArray4);
            double d6 = swaption.getValue(lIBORModelMonteCarloSimulationInterface);
            System.out.print(formatterValue.format(d6) + "           ");
            SwaptionSingleCurveAnalyticApproximation swaptionSingleCurveAnalyticApproximation = new SwaptionSingleCurveAnalyticApproximation(d5, dArray3, SwaptionSingleCurveAnalyticApproximation.ValueUnit.VALUE);
            double d7 = swaptionSingleCurveAnalyticApproximation.getValue(lIBORModelMonteCarloSimulationInterface);
            System.out.print(formatterValue.format(d7) + "         ");
            SwaptionAnalyticApproximation swaptionAnalyticApproximation = new SwaptionAnalyticApproximation(d5, dArray3, SwaptionAnalyticApproximation.ValueUnit.VALUE);
            double d8 = swaptionAnalyticApproximation.getValue(lIBORModelMonteCarloSimulationInterface);
            System.out.print(formatterValue.format(d8) + "          ");
            double d9 = d8 - d6;
            System.out.print(formatterDeviation.format(d9) + "           ");
            double d10 = d8 - d7;
            System.out.println(formatterDeviation.format(d10));
            d = Math.max(d, Math.abs(d9));
            d2 = Math.max(d2, Math.abs(d10));
        }
        System.out.println("__________________________________________________________________________________________\n");
        Assert.assertEquals((String)"Deviation", (double)0.0, (double)d, (double)0.005);
        Assert.assertTrue((bl || Math.abs(d2) < 1.0E-15 ? 1 : 0) != 0);
    }

    public static LIBORModelMonteCarloSimulationInterface createSingleCurveLIBORMarketModel(int n, int n2, double d) throws CalculationException {
        ForwardCurve forwardCurve = ForwardCurve.createForwardCurveFromForwards("forwardCurve", new double[]{0.5, 1.0, 2.0, 5.0, 40.0}, new double[]{0.05, 0.05, 0.05, 0.05, 0.05}, 0.5);
        DiscountCurveInterface discountCurveInterface = null;
        return SwaptionAnalyticApproximationTest.createLIBORMarketModel(n, n2, d, discountCurveInterface, forwardCurve);
    }

    public static LIBORModelMonteCarloSimulationInterface createMultiCurveLIBORMarketModel(int n, int n2, double d) throws CalculationException {
        ForwardCurve forwardCurve = ForwardCurve.createForwardCurveFromForwards("forwardCurve", new double[]{0.5, 1.0, 2.0, 5.0, 40.0}, new double[]{0.05, 0.05, 0.05, 0.05, 0.05}, 0.5);
        DiscountCurve discountCurve = DiscountCurve.createDiscountCurveFromZeroRates("discountCurve", new double[]{0.5, 1.0, 2.0, 5.0, 40.0}, new double[]{0.04, 0.04, 0.04, 0.04, 0.05});
        return SwaptionAnalyticApproximationTest.createLIBORMarketModel(n, n2, d, discountCurve, forwardCurve);
    }

    public static LIBORModelMonteCarloSimulationInterface createLIBORMarketModel(int n, int n2, double d, DiscountCurveInterface discountCurveInterface, ForwardCurveInterface forwardCurveInterface) throws CalculationException {
        double d2 = 0.5;
        double d3 = 20.0;
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, (int)(d3 / d2), d2);
        double d4 = 20.0;
        double d5 = 0.5;
        TimeDiscretization timeDiscretization2 = new TimeDiscretization(0.0, (int)(d4 / d5), d5);
        double[][] dArray = new double[timeDiscretization2.getNumberOfTimeSteps()][timeDiscretization.getNumberOfTimeSteps()];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                double d6 = timeDiscretization2.getTime(i);
                double d7 = timeDiscretization.getTime(j);
                double d8 = d7 - d6;
                double d9 = d8 <= 0.0 ? 0.0 : 0.3 + 0.2 * Math.exp(-0.25 * d8);
                dArray[i][j] = d9;
            }
        }
        LIBORVolatilityModelFromGivenMatrix lIBORVolatilityModelFromGivenMatrix = new LIBORVolatilityModelFromGivenMatrix(timeDiscretization2, timeDiscretization, dArray);
        LIBORCorrelationModelExponentialDecay lIBORCorrelationModelExponentialDecay = new LIBORCorrelationModelExponentialDecay(timeDiscretization2, timeDiscretization, n2, d);
        LIBORCovarianceModelFromVolatilityAndCorrelation lIBORCovarianceModelFromVolatilityAndCorrelation = new LIBORCovarianceModelFromVolatilityAndCorrelation(timeDiscretization2, timeDiscretization, lIBORVolatilityModelFromGivenMatrix, lIBORCorrelationModelExponentialDecay);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("measure", LIBORMarketModel.Measure.SPOT.name());
        hashMap.put("stateSpace", LIBORMarketModel.StateSpace.LOGNORMAL.name());
        LIBORMarketModel.CalibrationItem[] calibrationItemArray = new LIBORMarketModel.CalibrationItem[]{};
        LIBORMarketModel lIBORMarketModel = new LIBORMarketModel((TimeDiscretizationInterface)timeDiscretization, forwardCurveInterface, discountCurveInterface, (AbstractLIBORCovarianceModel)lIBORCovarianceModelFromVolatilityAndCorrelation, calibrationItemArray, hashMap);
        ProcessEulerScheme processEulerScheme = new ProcessEulerScheme(new BrownianMotion(timeDiscretization2, n2, n, 3141));
        return new LIBORModelMonteCarloSimulation(lIBORMarketModel, processEulerScheme);
    }
}

