/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class SwaptionAnalyticApproximation
extends AbstractLIBORMonteCarloProduct {
    private final double swaprate;
    private final double[] swapTenor;
    private final ValueUnit valueUnit;
    private Map<String, double[]> cachedLogSwaprateDerivative;
    private WeakReference<TimeDiscretizationInterface> cachedLogSwaprateDerivativeTimeDiscretization;
    private WeakReference<DiscountCurveInterface> cachedLogSwaprateDerivativeDiscountCurve;
    private WeakReference<ForwardCurveInterface> cachedLogSwaprateDerivativeForwardCurve;
    private Object cachedLogSwaprateDerivativeLock = new Object();

    public SwaptionAnalyticApproximation(double d, TimeDiscretizationInterface timeDiscretizationInterface) {
        this(d, timeDiscretizationInterface.getAsDoubleArray(), ValueUnit.VALUE);
    }

    public SwaptionAnalyticApproximation(double d, double[] dArray, ValueUnit valueUnit) {
        this.swaprate = d;
        this.swapTenor = dArray;
        this.valueUnit = valueUnit;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) {
        return this.getValues(d, lIBORModelMonteCarloSimulationInterface.getModel());
    }

    public RandomVariableInterface getValues(double d, LIBORMarketModelInterface lIBORMarketModelInterface) {
        if (d > 0.0) {
            throw new RuntimeException("Forward start evaluation currently not supported.");
        }
        double d2 = this.swapTenor[0];
        double d3 = this.swapTenor[this.swapTenor.length - 1];
        int n = lIBORMarketModelInterface.getLiborPeriodIndex(d2);
        int n2 = lIBORMarketModelInterface.getLiborPeriodIndex(d3);
        int n3 = lIBORMarketModelInterface.getCovarianceModel().getTimeDiscretization().getTimeIndex(d2) - 1;
        Map<String, double[]> map = this.getLogSwaprateDerivative(lIBORMarketModelInterface.getLiborPeriodDiscretization(), lIBORMarketModelInterface.getDiscountCurve(), lIBORMarketModelInterface.getForwardRateCurve());
        double[] dArray = map.get("values");
        double[][] dArray2 = lIBORMarketModelInterface.getIntegratedLIBORCovariance()[n3];
        double d4 = 0.0;
        for (int i = n; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                d4 += 2.0 * dArray[i - n] * dArray[j - n] * dArray2[i][j];
            }
            d4 += dArray[i - n] * dArray[i - n] * dArray2[i][i];
        }
        if (this.valueUnit == ValueUnit.INTEGRATEDVARIANCE) {
            return new RandomVariable(d, d4);
        }
        double d5 = Math.sqrt(d4 / d2);
        if (this.valueUnit == ValueUnit.VOLATILITY) {
            return new RandomVariable(d, d5);
        }
        double d6 = Swap.getForwardSwapRate(new TimeDiscretization(this.swapTenor), new TimeDiscretization(this.swapTenor), lIBORMarketModelInterface.getForwardRateCurve(), lIBORMarketModelInterface.getDiscountCurve());
        double d7 = SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)new TimeDiscretization(this.swapTenor), lIBORMarketModelInterface.getDiscountCurve());
        double d8 = d2;
        double d9 = AnalyticFormulas.blackModelSwaptionValue(d6, d5, d8, this.swaprate, d7);
        return new RandomVariable(d, d9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, double[]> getLogSwaprateDerivative(TimeDiscretizationInterface timeDiscretizationInterface, DiscountCurveInterface discountCurveInterface, ForwardCurveInterface forwardCurveInterface) {
        Object object = this.cachedLogSwaprateDerivativeLock;
        synchronized (object) {
            double d;
            int n;
            double d2;
            if (this.cachedLogSwaprateDerivative != null && timeDiscretizationInterface == this.cachedLogSwaprateDerivativeTimeDiscretization.get() && discountCurveInterface == this.cachedLogSwaprateDerivativeDiscountCurve.get() && forwardCurveInterface == this.cachedLogSwaprateDerivativeForwardCurve.get()) {
                return this.cachedLogSwaprateDerivative;
            }
            this.cachedLogSwaprateDerivativeTimeDiscretization = new WeakReference<TimeDiscretizationInterface>(timeDiscretizationInterface);
            this.cachedLogSwaprateDerivativeDiscountCurve = new WeakReference<DiscountCurveInterface>(discountCurveInterface);
            this.cachedLogSwaprateDerivativeForwardCurve = new WeakReference<ForwardCurveInterface>(forwardCurveInterface);
            AnalyticModel analyticModel = null;
            if (discountCurveInterface == null) {
                discountCurveInterface = new DiscountCurveFromForwardCurve(forwardCurveInterface.getName());
                analyticModel = new AnalyticModel(new CurveInterface[]{forwardCurveInterface, discountCurveInterface});
            }
            double d3 = this.swapTenor[0];
            double d4 = this.swapTenor[this.swapTenor.length - 1];
            int n2 = timeDiscretizationInterface.getTimeIndex(d3);
            int n3 = timeDiscretizationInterface.getTimeIndex(d4);
            double[] dArray = new double[n3 - n2 + 1];
            double[] dArray2 = new double[n3 - n2 + 1];
            dArray2[0] = discountCurveInterface.getDiscountFactor(analyticModel, d3);
            for (int i = n2; i < n3; ++i) {
                dArray[i - n2] = d2 = forwardCurveInterface.getForward(null, timeDiscretizationInterface.getTime(i));
                dArray2[i - n2 + 1] = discountCurveInterface.getDiscountFactor(analyticModel, timeDiscretizationInterface.getTime(i + 1));
            }
            double[] dArray3 = new double[this.swapTenor.length - 1];
            d2 = 0.0;
            for (int i = this.swapTenor.length - 2; i >= 0; --i) {
                int n4 = timeDiscretizationInterface.getTimeIndex(this.swapTenor[i + 1]);
                dArray3[i] = d2 += dArray2[n4 - n2] * (this.swapTenor[i + 1] - this.swapTenor[i]);
            }
            double[] dArray4 = new double[n3 - n2];
            double d5 = 0.0;
            for (n = n2; n < n3; ++n) {
                d = timeDiscretizationInterface.getTimeStep(n);
                d5 += dArray[n - n2] * dArray2[n - n2 + 1] * d;
            }
            n = 0;
            d = 0.0;
            for (int i = n2; i < n3; ++i) {
                if (timeDiscretizationInterface.getTime(i) >= this.swapTenor[n + 1]) {
                    ++n;
                }
                double d6 = dArray[i - n2];
                double d7 = timeDiscretizationInterface.getTimeStep(i);
                double d8 = discountCurveInterface.getDiscountFactor(analyticModel, timeDiscretizationInterface.getTime(i + 1));
                double d9 = (d8 + (d += dArray[i - n2] * dArray2[i - n2 + 1] * d7) - d5) * d7 / (1.0 + d6 * d7) / d5;
                double d10 = -dArray3[n] / d2 * d7 / (1.0 + d6 * d7);
                dArray4[i - n2] = (d9 - d10) * d6;
            }
            HashMap<String, double[]> hashMap = new HashMap<String, double[]>();
            hashMap.put("values", dArray4);
            hashMap.put("discountFactors", dArray2);
            hashMap.put("swapAnnuities", dArray3);
            this.cachedLogSwaprateDerivative = hashMap;
            return hashMap;
        }
    }

    public static double[][][] getIntegratedLIBORCovariance(LIBORMarketModel lIBORMarketModel) {
        return lIBORMarketModel.getIntegratedLIBORCovariance();
    }

    public static enum ValueUnit {
        VALUE,
        INTEGRATEDVARIANCE,
        VOLATILITY;

    }
}

