/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.GregorianCalendar;
import java.util.HashMap;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModelExponentialDecay;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCovarianceModelFromVolatilityAndCorrelation;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModelFromGivenMatrix;
import net.finmath.montecarlo.interestrate.products.SwapLeg;
import net.finmath.montecarlo.interestrate.products.components.Notional;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.montecarlo.interestrate.products.indices.LIBORIndex;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;
import org.junit.Assert;
import org.junit.Test;

public class SwapLegTest {
    @Test
    public void testFloatLeg() throws CalculationException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2014, 7, 12);
        int n = 2;
        String string = "0D";
        String string2 = "35Y";
        String string3 = "semiannual";
        String string4 = "30/360";
        Notional notional = new Notional(1.0);
        LIBORIndex lIBORIndex = new LIBORIndex(0.0, 0.5);
        double d = 0.0;
        ScheduleInterface scheduleInterface = ScheduleGenerator.createScheduleFromConventions(gregorianCalendar.getTime(), n, string, string2, string3, string4, "first", "following", new BusinessdayCalendarExcludingTARGETHolidays(), -2, 0);
        SwapLeg swapLeg = new SwapLeg(scheduleInterface, notional, lIBORIndex, d, false);
        int n2 = 10000;
        int n3 = 5;
        double d2 = 0.2;
        LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface = SwapLegTest.createMultiCurveLIBORMarketModel(n2, n3, d2);
        RandomVariableInterface randomVariableInterface = swapLeg.getValue(0.0, lIBORModelMonteCarloSimulationInterface);
        double d3 = randomVariableInterface.getAverage();
        System.out.println("Float leg (simulation): " + randomVariableInterface.getAverage() + "\t +/-" + randomVariableInterface.getStandardError());
        String string5 = "forwardCurve";
        String string6 = "discountCurve";
        net.finmath.marketdata.products.SwapLeg swapLeg2 = new net.finmath.marketdata.products.SwapLeg(scheduleInterface, string5, d, string6, false);
        AnalyticModelInterface analyticModelInterface = lIBORModelMonteCarloSimulationInterface.getModel().getAnalyticModel();
        double d4 = swapLeg2.getValue(0.0, analyticModelInterface);
        System.out.println("Float leg (analytic)..: " + d4);
        Assert.assertEquals((String)"Monte-Carlo value", (double)d4, (double)d3, (double)0.004);
    }

    @Test
    public void testFixLeg() throws CalculationException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2014, 7, 12);
        int n = 2;
        String string = "0D";
        String string2 = "35Y";
        String string3 = "semiannual";
        String string4 = "30/360";
        Notional notional = new Notional(1.0);
        AbstractIndex abstractIndex = null;
        double d = 0.05;
        ScheduleInterface scheduleInterface = ScheduleGenerator.createScheduleFromConventions(gregorianCalendar.getTime(), n, string, string2, string3, string4, "first", "following", new BusinessdayCalendarExcludingTARGETHolidays(), -2, 0);
        SwapLeg swapLeg = new SwapLeg(scheduleInterface, notional, abstractIndex, d, false);
        int n2 = 10000;
        int n3 = 5;
        double d2 = 0.2;
        LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface = SwapLegTest.createMultiCurveLIBORMarketModel(n2, n3, d2);
        RandomVariableInterface randomVariableInterface = swapLeg.getValue(0.0, lIBORModelMonteCarloSimulationInterface);
        double d3 = randomVariableInterface.getAverage();
        System.out.println("Fixed leg (simulation): " + randomVariableInterface.getAverage() + "\t +/-" + randomVariableInterface.getStandardError());
        String string5 = null;
        String string6 = "discountCurve";
        net.finmath.marketdata.products.SwapLeg swapLeg2 = new net.finmath.marketdata.products.SwapLeg(scheduleInterface, string5, d, string6, false);
        AnalyticModelInterface analyticModelInterface = lIBORModelMonteCarloSimulationInterface.getModel().getAnalyticModel();
        double d4 = swapLeg2.getValue(0.0, analyticModelInterface);
        System.out.println("Fixed leg (analytic)..: " + d4);
        Assert.assertEquals((String)"Monte-Carlo value", (double)d4, (double)d3, (double)0.004);
    }

    public static LIBORModelMonteCarloSimulationInterface createMultiCurveLIBORMarketModel(int n, int n2, double d) throws CalculationException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2014, 7, 12);
        ForwardCurve forwardCurve = ForwardCurve.createForwardCurveFromForwards("forwardCurve", gregorianCalendar, "6M", (BusinessdayCalendarInterface)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendarInterface.DateRollConvention.FOLLOWING, Curve.InterpolationMethod.LINEAR, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.VALUE, ForwardCurve.InterpolationEntityForward.FORWARD, null, null, new double[]{0.5, 1.0, 2.0, 5.0, 40.0}, new double[]{0.05, 0.05, 0.05, 0.05, 0.05});
        DiscountCurve discountCurve = DiscountCurve.createDiscountCurveFromZeroRates("discountCurve", new double[]{0.5, 1.0, 2.0, 5.0, 40.0}, new double[]{0.04, 0.04, 0.04, 0.04, 0.05});
        return SwapLegTest.createLIBORMarketModel(n, n2, d, discountCurve, forwardCurve);
    }

    public static LIBORModelMonteCarloSimulationInterface createLIBORMarketModel(int n, int n2, double d, DiscountCurveInterface discountCurveInterface, ForwardCurveInterface forwardCurveInterface) throws CalculationException {
        AnalyticModel analyticModel = new AnalyticModel(new CurveInterface[]{forwardCurveInterface, discountCurveInterface});
        double d2 = 0.5;
        double d3 = 40.0;
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, (int)(d3 / d2), d2);
        double d4 = 40.0;
        double d5 = 0.5;
        TimeDiscretization timeDiscretization2 = new TimeDiscretization(0.0, (int)(d4 / d5), d5);
        double[][] dArray = new double[timeDiscretization2.getNumberOfTimeSteps()][timeDiscretization.getNumberOfTimeSteps()];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                double d6 = timeDiscretization2.getTime(i);
                double d7 = timeDiscretization.getTime(j);
                double d8 = d7 - d6;
                double d9 = d8 <= 0.0 ? 0.0 : 0.3 + 0.2 * Math.exp(-0.25 * d8);
                dArray[i][j] = d9;
            }
        }
        LIBORVolatilityModelFromGivenMatrix lIBORVolatilityModelFromGivenMatrix = new LIBORVolatilityModelFromGivenMatrix(timeDiscretization2, timeDiscretization, dArray);
        LIBORCorrelationModelExponentialDecay lIBORCorrelationModelExponentialDecay = new LIBORCorrelationModelExponentialDecay(timeDiscretization2, timeDiscretization, n2, d);
        LIBORCovarianceModelFromVolatilityAndCorrelation lIBORCovarianceModelFromVolatilityAndCorrelation = new LIBORCovarianceModelFromVolatilityAndCorrelation(timeDiscretization2, timeDiscretization, lIBORVolatilityModelFromGivenMatrix, lIBORCorrelationModelExponentialDecay);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("measure", LIBORMarketModel.Measure.SPOT.name());
        hashMap.put("stateSpace", LIBORMarketModel.StateSpace.LOGNORMAL.name());
        LIBORMarketModel.CalibrationItem[] calibrationItemArray = new LIBORMarketModel.CalibrationItem[]{};
        LIBORMarketModel lIBORMarketModel = new LIBORMarketModel(timeDiscretization, analyticModel, forwardCurveInterface, discountCurveInterface, lIBORCovarianceModelFromVolatilityAndCorrelation, calibrationItemArray, hashMap);
        ProcessEulerScheme processEulerScheme = new ProcessEulerScheme(new BrownianMotion(timeDiscretization2, n2, n, 3141));
        return new LIBORModelMonteCarloSimulation(lIBORMarketModel, processEulerScheme);
    }
}

