/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class FlexiCap
extends AbstractLIBORMonteCarloProduct {
    private final double[] fixingDates;
    private final double[] paymentDates;
    private final double[] strikes;
    private final int maximumNumberOfExercises;

    public FlexiCap(double[] dArray, double[] dArray2, double[] dArray3, int n) {
        this.fixingDates = dArray;
        this.paymentDates = dArray2;
        this.strikes = dArray3;
        this.maximumNumberOfExercises = n;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = new RandomVariable(0.0);
        RandomVariableInterface randomVariableInterface2 = new RandomVariable((double)this.maximumNumberOfExercises - 0.5);
        for (int i = 0; i < this.fixingDates.length; ++i) {
            double d2 = this.fixingDates[i];
            double d3 = this.paymentDates[i];
            if (d > d3) continue;
            double d4 = this.strikes[i];
            double d5 = d3 - d2;
            RandomVariableInterface randomVariableInterface3 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d2, d2, d3);
            RandomVariableInterface randomVariableInterface4 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d3);
            RandomVariableInterface randomVariableInterface5 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(lIBORModelMonteCarloSimulationInterface.getTimeIndex(d3));
            RandomVariableInterface randomVariableInterface6 = randomVariableInterface3.sub(d4).mult(d5);
            RandomVariableInterface randomVariableInterface7 = new RandomVariable(1.0).barrier(randomVariableInterface6, (RandomVariableInterface)new RandomVariable(1.0), new RandomVariable(0.0));
            randomVariableInterface7 = randomVariableInterface7.barrier(randomVariableInterface2, randomVariableInterface7, 0.0);
            randomVariableInterface6 = randomVariableInterface6.div(randomVariableInterface4).mult(randomVariableInterface5);
            randomVariableInterface = randomVariableInterface.addProduct(randomVariableInterface7, randomVariableInterface6);
            randomVariableInterface2 = randomVariableInterface2.sub(randomVariableInterface7);
        }
        RandomVariableInterface randomVariableInterface8 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface9 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        randomVariableInterface = randomVariableInterface.mult(randomVariableInterface8).div(randomVariableInterface9);
        return randomVariableInterface;
    }

    public double[] getStrikes() {
        return this.strikes;
    }
}

