/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class DigitalCaplet
extends AbstractLIBORMonteCarloProduct {
    private final double optionMaturity;
    private final double periodStart;
    private final double periodEnd;
    private final double strike;

    public DigitalCaplet(double d, double d2, double d3, double d4) {
        this.optionMaturity = d;
        this.periodStart = d2;
        this.periodEnd = d3;
        this.strike = d4;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        double d2 = this.periodEnd;
        double d3 = this.periodEnd - this.periodStart;
        RandomVariableInterface randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getLIBOR(this.optionMaturity, this.periodStart, this.periodEnd);
        RandomVariableInterface randomVariableInterface2 = randomVariableInterface.sub(this.strike).mult(d3);
        RandomVariableInterface randomVariableInterface3 = new RandomVariable(1.0).barrier(randomVariableInterface2, (RandomVariableInterface)new RandomVariable(d3), new RandomVariable(0.0));
        RandomVariableInterface randomVariableInterface4 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d2);
        RandomVariableInterface randomVariableInterface5 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(d2);
        randomVariableInterface3 = randomVariableInterface3.div(randomVariableInterface4).mult(randomVariableInterface5);
        RandomVariableInterface randomVariableInterface6 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface7 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        randomVariableInterface3 = randomVariableInterface3.mult(randomVariableInterface6).div(randomVariableInterface7);
        return randomVariableInterface3;
    }
}

