/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class Bond
extends AbstractLIBORMonteCarloProduct {
    private double maturity;

    public Bond(double d) {
        this.maturity = d;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getNumeraire(this.maturity);
        RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(this.maturity);
        RandomVariableInterface randomVariableInterface3 = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        randomVariableInterface3 = randomVariableInterface3.div(randomVariableInterface).mult(randomVariableInterface2);
        RandomVariableInterface randomVariableInterface4 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface5 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        randomVariableInterface3 = randomVariableInterface3.mult(randomVariableInterface4).div(randomVariableInterface5);
        return randomVariableInterface3;
    }

    public double getMaturity() {
        return this.maturity;
    }

    public void setMaturity(double d) {
        this.maturity = d;
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + "maturity: " + this.maturity;
    }
}

