/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.marketdata.model.volatilities.CapletVolatilitiesParametric;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelFourParameterExponentialFormIntegrated
extends LIBORVolatilityModel {
    private double a;
    private double b;
    private double c;
    private double d;
    private boolean isCalibrateable = false;
    private transient CapletVolatilitiesParametric cap;

    public LIBORVolatilityModelFourParameterExponentialFormIntegrated(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, double d, double d2, double d3, double d4, boolean bl) {
        super(timeDiscretizationInterface, timeDiscretizationInterface2);
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.isCalibrateable = bl;
        this.cap = new CapletVolatilitiesParametric("", null, d, d2, d3, d4);
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        double[] dArray = new double[]{this.a, this.b, this.c, this.d};
        return dArray;
    }

    @Override
    public void setParameter(double[] dArray) {
        if (!this.isCalibrateable) {
            return;
        }
        this.a = dArray[0];
        this.b = dArray[1];
        this.c = dArray[2];
        this.d = dArray[3];
        this.cap = new CapletVolatilitiesParametric("", null, this.a, this.b, this.c, this.d);
    }

    @Override
    public RandomVariableInterface getVolatility(int n, int n2) {
        double d = this.getTimeDiscretization().getTime(n);
        double d2 = this.getTimeDiscretization().getTime(n + 1);
        double d3 = this.getLiborPeriodDiscretization().getTime(n2);
        double d4 = this.cap.getValue(d3 - d, 0.0, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
        double d5 = this.cap.getValue(d3 - d2, 0.0, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
        double d6 = (d4 * d4 * (d3 - d) - d5 * d5 * (d3 - d2)) / (d2 - d);
        d6 = Math.max(d6, 0.0);
        return new RandomVariable(Math.sqrt(d6));
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelFourParameterExponentialFormIntegrated(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.a, this.b, this.c, this.d, this.isCalibrateable);
    }
}

