/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.functions.LinearAlgebra;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModel;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORCorrelationModelThreeParameterExponentialDecay
extends LIBORCorrelationModel {
    private int numberOfFactors;
    private double a;
    private double b;
    private double c;
    private final boolean isCalibrateable;
    private transient double[][] correlationMatrix;
    private transient double[][] factorMatrix;

    public LIBORCorrelationModelThreeParameterExponentialDecay(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, int n, double d, double d2, double d3, boolean bl) {
        super(timeDiscretizationInterface, timeDiscretizationInterface2);
        this.numberOfFactors = n;
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.isCalibrateable = bl;
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        double[] dArray = new double[]{this.a, this.b, this.c};
        return dArray;
    }

    @Override
    public void setParameter(double[] dArray) {
        if (!this.isCalibrateable) {
            return;
        }
        this.a = dArray[0];
        this.b = dArray[1];
        this.c = dArray[2];
        this.factorMatrix = null;
        this.correlationMatrix = null;
    }

    @Override
    public double getFactorLoading(int n, int n2, int n3) {
        if (this.factorMatrix == null) {
            this.initialize(this.numberOfFactors, this.a, this.b, this.c);
        }
        return this.factorMatrix[n3][n2];
    }

    @Override
    public double getCorrelation(int n, int n2, int n3) {
        if (this.correlationMatrix == null) {
            this.initialize(this.numberOfFactors, this.a, this.b, this.c);
        }
        return this.correlationMatrix[n2][n3];
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    private synchronized void initialize(int n, double d, double d2, double d3) {
        double d4;
        int n2;
        int n3;
        d = Math.max(d, 0.0);
        d2 = Math.min(Math.max(d2, 0.0), 1.0);
        d3 = Math.max(d3, 0.0);
        this.correlationMatrix = new double[this.liborPeriodDiscretization.getNumberOfTimeSteps()][this.liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (n3 = 0; n3 < this.correlationMatrix.length; ++n3) {
            for (n2 = n3 + 1; n2 < this.correlationMatrix[n3].length; ++n2) {
                double d5;
                d4 = this.liborPeriodDiscretization.getTime(n3);
                double d6 = this.liborPeriodDiscretization.getTime(n2);
                this.correlationMatrix[n3][n2] = d5 = d2 + (1.0 - d2) * Math.exp(-d * Math.abs(d4 - d6) - d3 * Math.max(d4, d6));
                this.correlationMatrix[n2][n3] = d5;
            }
            this.correlationMatrix[n3][n3] = 1.0;
        }
        this.factorMatrix = LinearAlgebra.factorReduction(this.correlationMatrix, n);
        for (n3 = 0; n3 < this.factorMatrix.length; ++n3) {
            for (n2 = n3 + 1; n2 < this.factorMatrix.length; ++n2) {
                d4 = 0.0;
                for (int i = 0; i < this.factorMatrix[n3].length; ++i) {
                    d4 += this.factorMatrix[n3][i] * this.factorMatrix[n2][i];
                }
                this.correlationMatrix[n3][n2] = d4;
                this.correlationMatrix[n2][n3] = d4;
            }
            this.correlationMatrix[n3][n3] = 1.0;
        }
    }

    @Override
    public Object clone() {
        this.initialize(this.numberOfFactors, this.a, this.b, this.c);
        LIBORCorrelationModelThreeParameterExponentialDecay lIBORCorrelationModelThreeParameterExponentialDecay = new LIBORCorrelationModelThreeParameterExponentialDecay(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.numberOfFactors, this.a, this.b, this.c, this.isCalibrateable);
        lIBORCorrelationModelThreeParameterExponentialDecay.correlationMatrix = this.correlationMatrix;
        lIBORCorrelationModelThreeParameterExponentialDecay.factorMatrix = this.factorMatrix;
        return lIBORCorrelationModelThreeParameterExponentialDecay;
    }
}

