/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.util.ArrayList;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.AbstractSwaptionMarketData;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximation;
import net.finmath.montecarlo.interestrate.products.SwaptionSimple;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.RegularSchedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORMarketModelStandard
extends AbstractModel
implements LIBORMarketModelInterface {
    private final TimeDiscretizationInterface liborPeriodDiscretization;
    private String forwardCurveName;
    private AnalyticModelInterface curveModel;
    private ForwardCurveInterface forwardRateCurve;
    private DiscountCurveInterface discountCurve;
    private AbstractLIBORCovarianceModel covarianceModel;
    private AbstractSwaptionMarketData swaptionMarketData;
    private Driftapproximation driftApproximationMethod = Driftapproximation.EULER;
    private Measure measure = Measure.SPOT;
    private double[][][] integratedLIBORCovariance;

    public LIBORMarketModelStandard(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel) {
        this.liborPeriodDiscretization = timeDiscretizationInterface;
        this.forwardRateCurve = forwardCurveInterface;
        this.covarianceModel = abstractLIBORCovarianceModel;
    }

    public LIBORMarketModelStandard(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel) {
        this.liborPeriodDiscretization = timeDiscretizationInterface;
        this.forwardRateCurve = forwardCurveInterface;
        this.discountCurve = discountCurveInterface;
        this.covarianceModel = abstractLIBORCovarianceModel;
    }

    public LIBORMarketModelStandard(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel, AbstractSwaptionMarketData abstractSwaptionMarketData) throws CalculationException {
        this(timeDiscretizationInterface, forwardCurveInterface, null, abstractLIBORCovarianceModel, LIBORMarketModelStandard.getCalibrationItems(timeDiscretizationInterface, forwardCurveInterface, abstractSwaptionMarketData));
    }

    public LIBORMarketModelStandard(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel, AbstractSwaptionMarketData abstractSwaptionMarketData) throws CalculationException {
        this(timeDiscretizationInterface, forwardCurveInterface, discountCurveInterface, abstractLIBORCovarianceModel, LIBORMarketModelStandard.getCalibrationItems(timeDiscretizationInterface, forwardCurveInterface, abstractSwaptionMarketData));
    }

    public LIBORMarketModelStandard(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel, CalibrationItem[] calibrationItemArray) throws CalculationException {
        this.liborPeriodDiscretization = timeDiscretizationInterface;
        double[] dArray = new double[timeDiscretizationInterface.getNumberOfTimeSteps()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = timeDiscretizationInterface.getTime(i);
        }
        AbstractLIBORCovarianceModelParametric abstractLIBORCovarianceModelParametric = null;
        try {
            abstractLIBORCovarianceModelParametric = (AbstractLIBORCovarianceModelParametric)abstractLIBORCovarianceModel;
        }
        catch (Exception exception) {
            throw new ClassCastException("Calibration is currently restricted to parametric covariance models (AbstractLIBORCovarianceModelParametric).");
        }
        this.forwardRateCurve = forwardCurveInterface;
        this.discountCurve = discountCurveInterface;
        AbstractLIBORMonteCarloProduct[] abstractLIBORMonteCarloProductArray = new AbstractLIBORMonteCarloProduct[calibrationItemArray.length];
        double[] dArray2 = new double[calibrationItemArray.length];
        double[] dArray3 = new double[calibrationItemArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            abstractLIBORMonteCarloProductArray[i] = calibrationItemArray[i].calibrationProduct;
            dArray2[i] = calibrationItemArray[i].calibrationTargetValue;
            dArray3[i] = calibrationItemArray[i].calibrationWeight;
        }
        this.covarianceModel = abstractLIBORCovarianceModelParametric.getCloneCalibrated(this, abstractLIBORMonteCarloProductArray, dArray2, dArray3);
    }

    private static CalibrationItem[] getCalibrationItems(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, AbstractSwaptionMarketData abstractSwaptionMarketData) {
        if (abstractSwaptionMarketData == null) {
            return null;
        }
        TimeDiscretizationInterface timeDiscretizationInterface2 = abstractSwaptionMarketData.getOptionMaturities();
        TimeDiscretizationInterface timeDiscretizationInterface3 = abstractSwaptionMarketData.getTenor();
        double d = abstractSwaptionMarketData.getSwapPeriodLength();
        ArrayList<CalibrationItem> arrayList = new ArrayList<CalibrationItem>();
        for (int i = 0; i <= timeDiscretizationInterface2.getNumberOfTimeSteps(); ++i) {
            for (int j = 0; j <= timeDiscretizationInterface3.getNumberOfTimeSteps() - i; ++j) {
                double d2;
                AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct;
                int n;
                double d3 = timeDiscretizationInterface2.getTime(i);
                double d4 = timeDiscretizationInterface3.getTime(j);
                if (timeDiscretizationInterface.getTimeIndex(d3) < 0 || timeDiscretizationInterface.getTimeIndex(d3 + d4) <= timeDiscretizationInterface.getTimeIndex(d3)) continue;
                int n2 = (int)(d4 / d);
                double[] dArray = new double[n2];
                double[] dArray2 = new double[n2];
                double[] dArray3 = new double[n2 + 1];
                for (int k = 0; k < n2; ++k) {
                    dArray[k] = d3 + (double)k * d;
                    dArray2[k] = d3 + (double)(k + 1) * d;
                    dArray3[k] = d3 + (double)k * d;
                }
                dArray3[n2] = d3 + (double)n2 * d;
                RegularSchedule regularSchedule = new RegularSchedule(new TimeDiscretization(dArray3));
                double d5 = Swap.getForwardSwapRate(regularSchedule, regularSchedule, forwardCurveInterface, null);
                double[] dArray4 = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArray4[n] = d5;
                }
                n = 1;
                if (n != 0) {
                    abstractLIBORMonteCarloProduct = new SwaptionAnalyticApproximation(d5, dArray3, SwaptionAnalyticApproximation.ValueUnit.VOLATILITY);
                    d2 = abstractSwaptionMarketData.getVolatility(d3, d4, abstractSwaptionMarketData.getSwapPeriodLength(), d5);
                    arrayList.add(new CalibrationItem(abstractLIBORMonteCarloProduct, d2, 1.0));
                    continue;
                }
                abstractLIBORMonteCarloProduct = new SwaptionSimple(d5, dArray3, SwaptionSimple.ValueUnit.VALUE);
                d2 = Swap.getForwardSwapRate(regularSchedule, regularSchedule, forwardCurveInterface);
                double d6 = SwapAnnuity.getSwapAnnuity((ScheduleInterface)regularSchedule, forwardCurveInterface);
                double d7 = abstractSwaptionMarketData.getVolatility(d3, d4, abstractSwaptionMarketData.getSwapPeriodLength(), d5);
                double d8 = AnalyticFormulas.blackModelSwaptionValue(d2, d7, d3, d5, d6);
                arrayList.add(new CalibrationItem(abstractLIBORMonteCarloProduct, d8, 1.0));
            }
        }
        return arrayList.toArray(new CalibrationItem[arrayList.size()]);
    }

    @Override
    public RandomVariableInterface getNumeraire(double d) throws CalculationException {
        int n = this.getLiborPeriodIndex(d);
        if (n < 0) {
            int n2 = -n - 1;
            int n3 = -n;
            double d2 = (d - this.getLiborPeriod(n2)) / (this.getLiborPeriod(n3) - this.getLiborPeriod(n2));
            return this.getNumeraire(this.getLiborPeriod(n3)).invert().mult(d2).add(this.getNumeraire(this.getLiborPeriod(n2)).invert().mult(1.0 - d2)).invert();
        }
        int n4 = this.getLiborPeriodIndex(d);
        if (n4 < 0) {
            throw new CalculationException("Simulation time discretization not part of forward rate tenor discretization.");
        }
        int n5 = this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1;
        if (this.measure == Measure.SPOT) {
            n4 = 0;
            n5 = this.getLiborPeriodIndex(d) - 1;
        }
        RandomVariableInterface randomVariableInterface = new RandomVariable(d, 1.0);
        for (int i = n4; i <= n5; ++i) {
            RandomVariableInterface randomVariableInterface2 = this.getLIBOR(this.getTimeIndex(Math.min(d, this.liborPeriodDiscretization.getTime(i))), i);
            double d3 = this.liborPeriodDiscretization.getTimeStep(i);
            randomVariableInterface = this.measure == Measure.SPOT ? randomVariableInterface.accrue(randomVariableInterface2, d3) : randomVariableInterface.discount(randomVariableInterface2, d3);
        }
        if (this.discountCurve != null) {
            DiscountCurveFromForwardCurve discountCurveFromForwardCurve = new DiscountCurveFromForwardCurve(this.forwardRateCurve);
            double d4 = discountCurveFromForwardCurve.getDiscountFactor(d) / this.discountCurve.getDiscountFactor(d);
            randomVariableInterface = randomVariableInterface.mult(d4);
        }
        return randomVariableInterface;
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        double[] dArray = new double[this.liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int i = 0; i < this.liborPeriodDiscretization.getNumberOfTimeSteps(); ++i) {
            double d = this.forwardRateCurve.getForward(null, this.liborPeriodDiscretization.getTime(i));
            dArray[i] = Math.log(d);
        }
        RandomVariableInterface[] randomVariableInterfaceArray = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            randomVariableInterfaceArray[i] = new RandomVariable(dArray[i]);
        }
        return randomVariableInterfaceArray;
    }

    @Override
    public RandomVariableInterface[] getDrift(int n, RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
        int n2;
        double d = this.getTime(n);
        int n3 = this.getLiborPeriodIndex(d) + 1;
        if (n3 < 0) {
            n3 = -n3 - 1 + 1;
        }
        RandomVariableInterface[] randomVariableInterfaceArray3 = new RandomVariableInterface[this.getNumberOfComponents()];
        RandomVariableInterface[][] randomVariableInterfaceArray4 = new RandomVariableInterface[this.getNumberOfComponents()][this.getNumberOfFactors()];
        for (n2 = n3; n2 < this.getNumberOfComponents(); ++n2) {
            randomVariableInterfaceArray3[n2] = new RandomVariable(0.0);
        }
        for (n2 = n3; n2 < this.getNumberOfComponents(); ++n2) {
            int n4;
            double d2 = this.liborPeriodDiscretization.getTimeStep(n2);
            RandomVariableInterface randomVariableInterface = randomVariableInterfaceArray[n2];
            RandomVariableInterface randomVariableInterface2 = randomVariableInterface.discount(randomVariableInterface, d2).mult(d2);
            RandomVariableInterface[] randomVariableInterfaceArray5 = this.getFactorLoading(n, n2, randomVariableInterfaceArray);
            RandomVariableInterface[] randomVariableInterfaceArray6 = new RandomVariableInterface[this.getNumberOfFactors()];
            for (n4 = 0; n4 < this.getNumberOfFactors(); ++n4) {
                randomVariableInterfaceArray6[n4] = randomVariableInterfaceArray5[n4].mult(randomVariableInterface2);
                randomVariableInterfaceArray4[n2][n4] = randomVariableInterfaceArray6[n4];
                if (n2 <= n3) continue;
                randomVariableInterfaceArray4[n2][n4] = randomVariableInterfaceArray4[n2][n4].add(randomVariableInterfaceArray4[n2 - 1][n4]);
            }
            for (n4 = 0; n4 < this.getNumberOfFactors(); ++n4) {
                randomVariableInterfaceArray3[n2] = randomVariableInterfaceArray3[n2].addProduct(randomVariableInterfaceArray4[n2][n4], randomVariableInterfaceArray5[n4]);
            }
        }
        if (this.measure == Measure.TERMINAL) {
            for (n2 = n3; n2 < this.getNumberOfComponents(); ++n2) {
                randomVariableInterfaceArray3[n2] = randomVariableInterfaceArray3[n2].sub(randomVariableInterfaceArray3[this.getNumberOfComponents() - 1]);
            }
        }
        for (n2 = n3; n2 < this.getNumberOfComponents(); ++n2) {
            RandomVariableInterface randomVariableInterface = this.covarianceModel.getCovariance(n, n2, n2, randomVariableInterfaceArray);
            randomVariableInterfaceArray3[n2] = randomVariableInterfaceArray3[n2].addProduct(randomVariableInterface, -0.5);
        }
        return randomVariableInterfaceArray3;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray) {
        return this.covarianceModel.getFactorLoading(n, n2, randomVariableInterfaceArray);
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int n, RandomVariableInterface randomVariableInterface) {
        return randomVariableInterface.exp();
    }

    public Driftapproximation getDriftApproximationMethod() {
        return this.driftApproximationMethod;
    }

    @Override
    public RandomVariableInterface getLIBOR(int n, int n2) throws CalculationException {
        return this.getProcessValue(n, n2);
    }

    @Override
    public int getNumberOfComponents() {
        return this.getNumberOfLibors();
    }

    @Override
    public int getNumberOfLibors() {
        return this.liborPeriodDiscretization.getNumberOfTimeSteps();
    }

    @Override
    public double getLiborPeriod(int n) {
        if (n >= this.liborPeriodDiscretization.getNumberOfTimes()) {
            throw new ArrayIndexOutOfBoundsException("Index for LIBOR period discretization out of bounds.");
        }
        return this.liborPeriodDiscretization.getTime(n);
    }

    @Override
    public int getLiborPeriodIndex(double d) {
        return this.liborPeriodDiscretization.getTimeIndex(d);
    }

    @Override
    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    private RandomVariableInterface getDrift(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
        if (this.getTime(n) >= this.getLiborPeriod(n2)) {
            return null;
        }
        if (this.driftApproximationMethod == Driftapproximation.PREDICTOR_CORRECTOR && randomVariableInterfaceArray2 != null) {
            RandomVariableInterface randomVariableInterface = this.getDriftEuler(n, n2, randomVariableInterfaceArray);
            RandomVariableInterface randomVariableInterface2 = this.getDriftEuler(n, n2, randomVariableInterfaceArray2);
            randomVariableInterface = randomVariableInterface.add(randomVariableInterface2).div(2.0);
            return randomVariableInterface;
        }
        if (this.driftApproximationMethod == Driftapproximation.LINE_INTEGRAL && randomVariableInterfaceArray2 != null) {
            return this.getDriftLineIntegral(n, n2, randomVariableInterfaceArray, randomVariableInterfaceArray2);
        }
        return this.getDriftEuler(n, n2, randomVariableInterfaceArray);
    }

    protected RandomVariableInterface getDriftEuler(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray) {
        int n3;
        double d = this.getTime(n);
        RandomVariableInterface randomVariableInterface = new RandomVariable(d, 0.0);
        switch (this.measure) {
            case SPOT: {
                int n4 = this.getLiborPeriodIndex(d) + 1;
                if (n4 < 0) {
                    n4 = -n4 - 1 + 1;
                }
                n3 = n2;
                break;
            }
            default: {
                int n4 = n2 + 1;
                n3 = this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1;
            }
        }
        for (int i = n4; i <= n3; ++i) {
            double d2 = this.liborPeriodDiscretization.getTimeStep(i);
            RandomVariableInterface randomVariableInterface2 = this.covarianceModel.getCovariance(n, n2, i, (RandomVariableInterface[])null);
            RandomVariableInterface randomVariableInterface3 = randomVariableInterfaceArray[i];
            randomVariableInterface2 = randomVariableInterface2.mult(d2).mult(randomVariableInterface3).discount(randomVariableInterface3, d2);
            randomVariableInterface = randomVariableInterface.add(randomVariableInterface2);
        }
        if (this.measure == Measure.TERMINAL) {
            randomVariableInterface = randomVariableInterface.mult(-1.0);
        }
        RandomVariableInterface randomVariableInterface4 = this.covarianceModel.getCovariance(n, n2, n2, (RandomVariableInterface[])null);
        randomVariableInterface = randomVariableInterface.addProduct(randomVariableInterface4, -0.5);
        return randomVariableInterface;
    }

    private RandomVariableInterface getDriftLineIntegral(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
        int n3;
        double d = this.getTime(n);
        if (this.getTime(n) >= this.getLiborPeriod(n2)) {
            return null;
        }
        RandomVariableInterface randomVariableInterface = new RandomVariable(d, 0.0);
        switch (this.measure) {
            case SPOT: {
                int n4 = this.getLiborPeriodIndex(d) + 1;
                if (n4 < 0) {
                    n4 = -n4 - 1 + 1;
                }
                n3 = n2;
                break;
            }
            default: {
                int n4 = n2 + 1;
                n3 = this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1;
            }
        }
        for (int i = n4; i <= n3; ++i) {
            double d2 = this.liborPeriodDiscretization.getTimeStep(i);
            RandomVariableInterface randomVariableInterface2 = this.covarianceModel.getCovariance(n, n2, i, (RandomVariableInterface[])null);
            RandomVariableInterface randomVariableInterface3 = new RandomVariable(1.0);
            randomVariableInterface3 = randomVariableInterface3.accrue(randomVariableInterfaceArray2[i], d2);
            randomVariableInterface3 = randomVariableInterface3.discount(randomVariableInterfaceArray[i], d2);
            randomVariableInterface3 = randomVariableInterface3.log();
            randomVariableInterface3 = randomVariableInterface3.mult(randomVariableInterface2);
            randomVariableInterface3 = randomVariableInterface3.div(randomVariableInterfaceArray2[i].div(randomVariableInterfaceArray[i]).log());
            randomVariableInterface = randomVariableInterface.sub(randomVariableInterface3);
        }
        return randomVariableInterface;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    @Override
    public synchronized double[][][] getIntegratedLIBORCovariance() {
        if (this.integratedLIBORCovariance != null) {
            return this.integratedLIBORCovariance;
        }
        TimeDiscretizationInterface timeDiscretizationInterface = this.getLiborPeriodDiscretization();
        TimeDiscretizationInterface timeDiscretizationInterface2 = this.getTimeDiscretization();
        this.integratedLIBORCovariance = new double[timeDiscretizationInterface2.getNumberOfTimeSteps()][timeDiscretizationInterface.getNumberOfTimeSteps()][timeDiscretizationInterface.getNumberOfTimeSteps()];
        for (int i = 0; i < timeDiscretizationInterface.getNumberOfTimeSteps(); ++i) {
            for (int j = i; j < timeDiscretizationInterface.getNumberOfTimeSteps(); ++j) {
                double d = 0.0;
                for (int k = 0; k < timeDiscretizationInterface2.getNumberOfTimeSteps(); ++k) {
                    double d2 = this.getTime(k + 1) - this.getTime(k);
                    RandomVariableInterface[] randomVariableInterfaceArray = this.getCovarianceModel().getFactorLoading(k, i, (RandomVariableInterface[])null);
                    RandomVariableInterface[] randomVariableInterfaceArray2 = this.getCovarianceModel().getFactorLoading(k, j, (RandomVariableInterface[])null);
                    for (int i2 = 0; i2 < this.getNumberOfFactors(); ++i2) {
                        d += randomVariableInterfaceArray[i2].get(0) * randomVariableInterfaceArray2[i2].get(0) * d2;
                    }
                    this.integratedLIBORCovariance[k][i][j] = d;
                }
            }
        }
        return this.integratedLIBORCovariance;
    }

    public Object clone() {
        return new LIBORMarketModelStandard(this.liborPeriodDiscretization, this.forwardRateCurve, this.covarianceModel);
    }

    public void setDriftApproximationMethod(Driftapproximation driftapproximation) {
        this.driftApproximationMethod = driftapproximation;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    @Override
    public AnalyticModelInterface getAnalyticModel() {
        return this.curveModel;
    }

    @Override
    public DiscountCurveInterface getDiscountCurve() {
        if (this.discountCurve == null) {
            DiscountCurveFromForwardCurve discountCurveFromForwardCurve = new DiscountCurveFromForwardCurve(this.getForwardRateCurve());
            return discountCurveFromForwardCurve;
        }
        return this.discountCurve;
    }

    @Override
    public ForwardCurveInterface getForwardRateCurve() {
        return this.forwardRateCurve;
    }

    public AbstractSwaptionMarketData getSwaptionMarketData() {
        return this.swaptionMarketData;
    }

    @Override
    public AbstractLIBORCovarianceModel getCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public LIBORMarketModelStandard getCloneWithModifiedCovarianceModel(AbstractLIBORCovarianceModel abstractLIBORCovarianceModel) {
        LIBORMarketModelStandard lIBORMarketModelStandard = (LIBORMarketModelStandard)this.clone();
        lIBORMarketModelStandard.covarianceModel = abstractLIBORCovarianceModel;
        return lIBORMarketModelStandard;
    }

    @Override
    public LIBORMarketModel getCloneWithModifiedData(Map<String, Object> map) throws CalculationException {
        TimeDiscretizationInterface timeDiscretizationInterface = this.liborPeriodDiscretization;
        AnalyticModelInterface analyticModelInterface = this.curveModel;
        ForwardCurveInterface forwardCurveInterface = this.forwardRateCurve;
        AbstractLIBORCovarianceModel abstractLIBORCovarianceModel = this.covarianceModel;
        AbstractSwaptionMarketData abstractSwaptionMarketData = null;
        if (map.containsKey("liborPeriodDiscretization")) {
            timeDiscretizationInterface = (TimeDiscretizationInterface)map.get("liborPeriodDiscretization");
        }
        if (map.containsKey("forwardRateCurve")) {
            forwardCurveInterface = (ForwardCurveInterface)map.get("forwardRateCurve");
        }
        if (map.containsKey("forwardRateShift")) {
            throw new RuntimeException("Forward rate shift clone currently disabled.");
        }
        if (map.containsKey("covarianceModel")) {
            abstractLIBORCovarianceModel = (AbstractLIBORCovarianceModel)map.get("covarianceModel");
        }
        if (map.containsKey("swaptionMarketData")) {
            abstractSwaptionMarketData = (AbstractSwaptionMarketData)map.get("swaptionMarketData");
        }
        if (abstractSwaptionMarketData == null) {
            return new LIBORMarketModel(timeDiscretizationInterface, forwardCurveInterface, abstractLIBORCovarianceModel);
        }
        return new LIBORMarketModel(timeDiscretizationInterface, forwardCurveInterface, abstractLIBORCovarianceModel, abstractSwaptionMarketData);
    }

    public static class CalibrationItem {
        public final AbstractLIBORMonteCarloProduct calibrationProduct;
        public final double calibrationTargetValue;
        public final double calibrationWeight;

        public CalibrationItem(AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct, double d, double d2) {
            this.calibrationProduct = abstractLIBORMonteCarloProduct;
            this.calibrationTargetValue = d;
            this.calibrationWeight = d2;
        }
    }

    public static enum Measure {
        SPOT,
        TERMINAL;

    }

    public static enum Driftapproximation {
        EULER,
        LINE_INTEGRAL,
        PREDICTOR_CORRECTOR;

    }
}

