/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.modelling.ModelInterface;
import net.finmath.modelling.ProductInterface;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetLIBORModelMonteCarloSimulationInterface;
import net.finmath.stochastic.RandomVariableInterface;

public class WorstOfExpressCertificate
implements ProductInterface {
    final double maturity;
    final double[] strikeLevels;
    final double[] exerciseDates;
    final double[] triggerPerformanceLevel;
    final double[] redemption;
    final double redemptionFinal;

    public WorstOfExpressCertificate(double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d2) {
        this.maturity = d;
        this.strikeLevels = dArray;
        this.exerciseDates = dArray2;
        this.triggerPerformanceLevel = dArray3;
        this.redemption = dArray4;
        this.redemptionFinal = d2;
    }

    @Override
    public Object getValue(double d, ModelInterface modelInterface) {
        return null;
    }

    public double getValue(double d, HybridAssetLIBORModelMonteCarloSimulationInterface hybridAssetLIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface;
        RandomVariableInterface randomVariableInterface2 = hybridAssetLIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        RandomVariableInterface randomVariableInterface3 = hybridAssetLIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        RandomVariableInterface randomVariableInterface4 = hybridAssetLIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        for (int i = 0; i < this.exerciseDates.length; ++i) {
            randomVariableInterface = WorstOfExpressCertificate.getWorstPerformance(hybridAssetLIBORModelMonteCarloSimulationInterface, this.exerciseDates[i], this.strikeLevels);
            RandomVariableInterface randomVariableInterface5 = randomVariableInterface.sub(this.triggerPerformanceLevel[i]);
            RandomVariableInterface randomVariableInterface6 = randomVariableInterface4.mult(this.redemption[i]);
            randomVariableInterface6 = randomVariableInterface6.div(hybridAssetLIBORModelMonteCarloSimulationInterface.getNumeraire(this.exerciseDates[i]));
            randomVariableInterface3 = randomVariableInterface3.add(randomVariableInterface5.barrier(randomVariableInterface5, randomVariableInterface6, 0.0));
            randomVariableInterface4 = randomVariableInterface4.barrier(randomVariableInterface5, randomVariableInterface2, randomVariableInterface4);
        }
        RandomVariableInterface randomVariableInterface7 = WorstOfExpressCertificate.getWorstPerformance(hybridAssetLIBORModelMonteCarloSimulationInterface, this.maturity, this.strikeLevels);
        randomVariableInterface = randomVariableInterface4.mult(randomVariableInterface7.mult(this.redemptionFinal));
        randomVariableInterface = randomVariableInterface.div(hybridAssetLIBORModelMonteCarloSimulationInterface.getNumeraire(this.maturity));
        randomVariableInterface3 = randomVariableInterface3.add(randomVariableInterface);
        randomVariableInterface3 = randomVariableInterface3.mult(hybridAssetLIBORModelMonteCarloSimulationInterface.getNumeraire(d));
        return randomVariableInterface3.getAverage();
    }

    private static RandomVariableInterface getWorstPerformance(HybridAssetLIBORModelMonteCarloSimulationInterface hybridAssetLIBORModelMonteCarloSimulationInterface, double d, double[] dArray) throws CalculationException {
        RandomVariableInterface randomVariableInterface = null;
        for (int i = 0; i < dArray.length; ++i) {
            RandomVariableInterface randomVariableInterface2 = hybridAssetLIBORModelMonteCarloSimulationInterface.getAssetValue(d, i);
            RandomVariableInterface randomVariableInterface3 = randomVariableInterface2.div(dArray[i]);
            randomVariableInterface = randomVariableInterface != null ? randomVariableInterface.cap(randomVariableInterface3) : randomVariableInterface3;
        }
        return randomVariableInterface;
    }
}

