/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class EuropeanOption
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final Integer underlyingIndex;
    private final String nameOfUnderliyng;

    public EuropeanOption(double d, double d2, int n) {
        this.maturity = d;
        this.strike = d2;
        this.underlyingIndex = n;
        this.nameOfUnderliyng = null;
    }

    public EuropeanOption(double d, double d2) {
        this(d, d2, 0);
    }

    @Override
    public RandomVariableInterface getValue(double d, AssetModelMonteCarloSimulationInterface assetModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = assetModelMonteCarloSimulationInterface.getAssetValue(this.maturity, (int)this.underlyingIndex);
        RandomVariableInterface randomVariableInterface2 = randomVariableInterface.sub(this.strike).floor(0.0);
        RandomVariableInterface randomVariableInterface3 = assetModelMonteCarloSimulationInterface.getNumeraire(this.maturity);
        RandomVariableInterface randomVariableInterface4 = assetModelMonteCarloSimulationInterface.getMonteCarloWeights(this.maturity);
        randomVariableInterface2 = randomVariableInterface2.div(randomVariableInterface3).mult(randomVariableInterface4);
        RandomVariableInterface randomVariableInterface5 = assetModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface6 = assetModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        randomVariableInterface2 = randomVariableInterface2.mult(randomVariableInterface5).div(randomVariableInterface6);
        return randomVariableInterface2;
    }
}

