/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Arrays;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.functions.LinearAlgebra;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class MonteCarloMultiAssetBlackScholesModel
extends AbstractModel
implements AssetModelMonteCarloSimulationInterface {
    private final double[] initialValues;
    private final double riskFreeRate;
    private final double[] volatilities;
    private final double[][] factorLoadings;
    private static final int seed = 3141;
    private final RandomVariableInterface[] initialStates;
    private final RandomVariableInterface[] drift;
    private final RandomVariableInterface[][] factorLoadingOnPaths;

    public MonteCarloMultiAssetBlackScholesModel(BrownianMotionInterface brownianMotionInterface, double[] dArray, double d, double[] dArray2, double[][] dArray3) {
        ProcessEulerScheme processEulerScheme = new ProcessEulerScheme(brownianMotionInterface);
        this.initialValues = dArray;
        this.riskFreeRate = d;
        this.volatilities = dArray2;
        this.factorLoadings = LinearAlgebra.getFactorMatrix(dArray3, dArray3.length);
        this.initialStates = new RandomVariableInterface[this.getNumberOfComponents()];
        this.drift = new RandomVariableInterface[this.getNumberOfComponents()];
        this.factorLoadingOnPaths = new RandomVariableInterface[this.getNumberOfComponents()][];
        for (int i = 0; i < dArray.length; ++i) {
            this.initialStates[i] = processEulerScheme.getBrownianMotion().getRandomVariableForConstant(Math.log(dArray[i]));
            this.drift[i] = processEulerScheme.getBrownianMotion().getRandomVariableForConstant(d - dArray2[i] * dArray2[i] / 2.0);
            this.factorLoadingOnPaths[i] = new RandomVariableInterface[processEulerScheme.getNumberOfFactors()];
            for (int j = 0; j < processEulerScheme.getNumberOfFactors(); ++j) {
                this.factorLoadingOnPaths[i][j] = processEulerScheme.getBrownianMotion().getRandomVariableForConstant(dArray2[i] * this.factorLoadings[i][j]);
            }
        }
        processEulerScheme.setModel(this);
        this.setProcess(processEulerScheme);
    }

    public MonteCarloMultiAssetBlackScholesModel(TimeDiscretizationInterface timeDiscretizationInterface, int n, double[] dArray, double d, double[] dArray2, double[][] dArray3) {
        this(new BrownianMotion(timeDiscretizationInterface, dArray.length, n, 3141), dArray, d, dArray2, dArray3);
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        return this.initialStates;
    }

    @Override
    public RandomVariableInterface[] getDrift(int n, RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
        return this.drift;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray) {
        return this.factorLoadingOnPaths[n2];
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int n, RandomVariableInterface randomVariableInterface) {
        return randomVariableInterface.exp();
    }

    @Override
    public RandomVariableInterface getAssetValue(double d, int n) throws CalculationException {
        int n2 = this.getTimeIndex(d);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        return this.getAssetValue(n2, n);
    }

    @Override
    public RandomVariableInterface getAssetValue(int n, int n2) throws CalculationException {
        return this.getProcessValue(n, n2);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double d) throws CalculationException {
        return this.getMonteCarloWeights(this.getTimeIndex(d));
    }

    @Override
    public RandomVariableInterface getNumeraire(int n) {
        double d = this.getTime(n);
        return this.getNumeraire(d);
    }

    @Override
    public RandomVariableInterface getNumeraire(double d) {
        double d2 = Math.exp(this.riskFreeRate * d);
        return this.getRandomVariableForConstant(d2);
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double d) {
        return this.getProcess().getBrownianMotion().getRandomVariableForConstant(d);
    }

    @Override
    public int getNumberOfComponents() {
        return this.initialValues.length;
    }

    @Override
    public int getNumberOfAssets() {
        return this.getNumberOfComponents();
    }

    public String toString() {
        return "MonteCarloMultiAssetBlackScholesModel [initialValues=" + Arrays.toString(this.initialValues) + ", riskFreeRate=" + this.riskFreeRate + ", volatilities=" + Arrays.toString(this.volatilities) + ", factorLoadings=" + Arrays.toString((Object[])this.factorLoadings) + "]";
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double[] getVolatilities() {
        return this.volatilities;
    }

    @Override
    public int getNumberOfPaths() {
        return this.getProcess().getNumberOfPaths();
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedData(Map<String, Object> map) throws CalculationException {
        double[] dArray = this.initialValues;
        double d = this.riskFreeRate;
        double[] dArray2 = this.volatilities;
        double[][] dArray3 = null;
        if (map.containsKey("initialValues")) {
            dArray = (double[])map.get("initialValues");
        }
        if (map.containsKey("riskFreeRate")) {
            d = (Double)map.get("riskFreeRate");
        }
        if (map.containsKey("volatilities")) {
            dArray2 = (double[])map.get("volatilities");
        }
        if (map.containsKey("correlations")) {
            dArray3 = (double[][])map.get("correlations");
        }
        return new MonteCarloMultiAssetBlackScholesModel(this.getTimeDiscretization(), this.getNumberOfPaths(), dArray, d, dArray2, dArray3);
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedSeed(int n) {
        return null;
    }
}

