/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.util.Arrays;
import net.finmath.stochastic.RandomVariableInterface;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.util.FastMath;

public class RandomVariable
implements RandomVariableInterface {
    private final double time;
    private final double[] realizations;
    private final double valueIfNonStochastic;

    public RandomVariable(RandomVariableInterface randomVariableInterface) {
        this.time = randomVariableInterface.getFiltrationTime();
        this.realizations = randomVariableInterface.isDeterministic() ? null : randomVariableInterface.getRealizations();
        this.valueIfNonStochastic = randomVariableInterface.isDeterministic() ? randomVariableInterface.get(0) : Double.NaN;
    }

    public RandomVariable(double d) {
        this(-1.7976931348623157E308, d);
    }

    public RandomVariable(double d, double d2) {
        this.time = d;
        this.realizations = null;
        this.valueIfNonStochastic = d2;
    }

    public RandomVariable(double d, int n, double d2) {
        this.time = d;
        this.realizations = new double[n];
        Arrays.fill(this.realizations, d2);
        this.valueIfNonStochastic = Double.NaN;
    }

    public RandomVariable(double d, double[] dArray) {
        this.time = d;
        this.realizations = dArray;
        this.valueIfNonStochastic = Double.NaN;
    }

    @Override
    public RandomVariable getMutableCopy() {
        return this;
    }

    @Override
    public boolean equals(RandomVariableInterface randomVariableInterface) {
        if (this.time != randomVariableInterface.getFiltrationTime()) {
            return false;
        }
        if (this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            return this.valueIfNonStochastic == randomVariableInterface.get(0);
        }
        if (this.isDeterministic() != randomVariableInterface.isDeterministic()) {
            return false;
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            if (this.realizations[i] == randomVariableInterface.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getFiltrationTime() {
        return this.time;
    }

    @Override
    public double get(int n) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        return this.realizations[n];
    }

    @Override
    public int size() {
        if (this.isDeterministic()) {
            return 1;
        }
        return this.realizations.length;
    }

    @Override
    public double getMin() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double d = Double.MAX_VALUE;
        if (this.realizations.length != 0) {
            d = this.realizations[0];
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            d = Math.min(this.realizations[i], d);
        }
        return d;
    }

    @Override
    public double getMax() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double d = -1.7976931348623157E308;
        if (this.realizations.length != 0) {
            d = this.realizations[0];
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            d = Math.max(this.realizations[i], d);
        }
        return d;
    }

    @Override
    public double getAverage() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double d3 = this.realizations[i] - d2;
            double d4 = d + d3;
            d2 = d4 - d - d3;
            d = d4;
        }
        return d / (double)this.realizations.length;
    }

    @Override
    public double getAverage(RandomVariableInterface randomVariableInterface) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double d3 = this.realizations[i] * randomVariableInterface.get(i) - d2;
            double d4 = d + d3;
            d2 = d4 - d - d3;
            d = d4;
        }
        return d / (double)this.realizations.length;
    }

    @Override
    public double getVariance() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double d5 = this.realizations[i] - d3;
            double d6 = d + d5;
            d3 = d6 - d - d5;
            d = d6;
            double d7 = this.realizations[i] * this.realizations[i] - d4;
            double d8 = d2 + d7;
            d4 = d8 - d2 - d7;
            d2 = d8;
        }
        return d2 / (double)this.realizations.length - d / (double)this.realizations.length * d / (double)this.realizations.length;
    }

    @Override
    public double getVariance(RandomVariableInterface randomVariableInterface) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double d5 = this.realizations[i] * randomVariableInterface.get(i) - d3;
            double d6 = d + d5;
            d3 = d6 - d - d5;
            d = d6;
            double d7 = this.realizations[i] * this.realizations[i] * randomVariableInterface.get(i) - d4;
            double d8 = d2 + d7;
            d4 = d8 - d2 - d7;
            d2 = d8;
        }
        return (d2 - d * d) / (double)this.realizations.length;
    }

    @Override
    public double getStandardDeviation() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance());
    }

    @Override
    public double getStandardDeviation(RandomVariableInterface randomVariableInterface) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance(randomVariableInterface));
    }

    @Override
    public double getStandardError() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation() / Math.sqrt(this.size());
    }

    @Override
    public double getStandardError(RandomVariableInterface randomVariableInterface) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation(randomVariableInterface) / Math.sqrt(this.size());
    }

    @Override
    public double getQuantile(double d) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double[] dArray = (double[])this.realizations.clone();
        Arrays.sort(dArray);
        int n = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * (1.0 - d) - 1.0), 0), this.size() - 1);
        return dArray[n];
    }

    @Override
    public double getQuantile(double d, RandomVariableInterface randomVariableInterface) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        throw new RuntimeException("Method not implemented.");
    }

    @Override
    public double getQuantileExpectation(double d, double d2) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (d > d2) {
            return this.getQuantileExpectation(d2, d);
        }
        double[] dArray = (double[])this.realizations.clone();
        Arrays.sort(dArray);
        int n = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * d - 1.0), 0), this.size() - 1);
        int n2 = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * d2 - 1.0), 0), this.size() - 1);
        double d3 = 0.0;
        for (int i = n; i <= n2; ++i) {
            d3 += dArray[i];
        }
        return d3 /= (double)(n2 - n + 1);
    }

    @Override
    public double[] getHistogram(double[] dArray) {
        double[] dArray2 = new double[dArray.length + 1];
        if (this.isDeterministic()) {
            Arrays.fill(dArray2, 0.0);
            for (int i = 0; i < dArray.length; ++i) {
                if (!(this.valueIfNonStochastic > dArray[i])) continue;
                dArray2[i] = 1.0;
                break;
            }
            dArray2[dArray.length] = 1.0;
        } else {
            int n;
            double[] dArray3 = (double[])this.realizations.clone();
            Arrays.sort(dArray3);
            int n2 = 0;
            for (n = 0; n < dArray.length; ++n) {
                int n3 = 0;
                while (n2 < dArray3.length && dArray3[n2] <= dArray[n]) {
                    ++n2;
                    ++n3;
                }
                dArray2[n] = n3;
            }
            dArray2[dArray.length] = dArray3.length - n2;
            if (dArray3.length > 0) {
                n = 0;
                while (n < dArray2.length) {
                    int n4 = n++;
                    dArray2[n4] = dArray2[n4] / (double)dArray3.length;
                }
            }
        }
        return dArray2;
    }

    @Override
    public double[][] getHistogram(int n, double d) {
        double[] dArray = new double[n];
        double[] dArray2 = new double[n + 1];
        double d2 = this.getAverage();
        double d3 = d * this.getStandardDeviation();
        double d4 = (double)(n - 1) / 2.0;
        for (int i = 0; i < n; ++i) {
            double d5 = (-((double)(n - 1)) / 2.0 + (double)i) / d4;
            dArray[i] = d2 + d5 * d3;
            dArray2[i] = d2 + d5 * d3 - d3 / (2.0 * d4);
        }
        dArray2[n] = d2 + 1.0 * d3 + d3 / (2.0 * d4);
        double[][] dArrayArray = new double[][]{dArray2, this.getHistogram(dArray)};
        return dArrayArray;
    }

    @Override
    public boolean isDeterministic() {
        return this.realizations == null;
    }

    public RandomVariableInterface expand(int n) {
        if (this.isDeterministic()) {
            double[] dArray = new double[n];
            Arrays.fill(dArray, this.valueIfNonStochastic);
            return new RandomVariable(this.time, dArray);
        }
        return new RandomVariable(this.time, (double[])this.realizations.clone());
    }

    @Override
    public RandomVariableInterface cache() {
        return this;
    }

    @Override
    public double[] getRealizations() {
        if (this.isDeterministic()) {
            double[] dArray = new double[]{this.get(0)};
            return dArray;
        }
        return (double[])this.realizations.clone();
    }

    @Override
    public double[] getRealizations(int n) {
        if (!this.isDeterministic() && this.realizations.length != n) {
            throw new RuntimeException("Inconsistent number of paths.");
        }
        return ((RandomVariable)this.expand((int)n)).realizations;
    }

    @Override
    public RandomVariableInterface apply(UnivariateFunction univariateFunction) {
        if (this.isDeterministic()) {
            double d = univariateFunction.value(this.valueIfNonStochastic);
            return new RandomVariable(this.time, d);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = univariateFunction.value(this.realizations[i]);
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface cap(double d) {
        if (this.isDeterministic()) {
            double d2 = Math.min(this.valueIfNonStochastic, d);
            return new RandomVariable(this.time, d2);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.min(this.realizations[i], d);
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface floor(double d) {
        if (this.isDeterministic()) {
            double d2 = Math.max(this.valueIfNonStochastic, d);
            return new RandomVariable(this.time, d2);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.max(this.realizations[i], d);
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface add(double d) {
        if (this.isDeterministic()) {
            double d2 = this.valueIfNonStochastic + d;
            return new RandomVariable(this.time, d2);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.realizations[i] + d;
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface sub(double d) {
        if (this.isDeterministic()) {
            double d2 = this.valueIfNonStochastic - d;
            return new RandomVariable(this.time, d2);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.realizations[i] - d;
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface mult(double d) {
        if (this.isDeterministic()) {
            double d2 = this.valueIfNonStochastic * d;
            return new RandomVariable(this.time, d2);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.realizations[i] * d;
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface div(double d) {
        if (this.isDeterministic()) {
            double d2 = this.valueIfNonStochastic / d;
            return new RandomVariable(this.time, d2);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.realizations[i] / d;
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface pow(double d) {
        if (this.isDeterministic()) {
            double d2 = Math.pow(this.valueIfNonStochastic, d);
            return new RandomVariable(this.time, d2);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.pow(this.realizations[i], d);
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface squared() {
        if (this.isDeterministic()) {
            double d = this.valueIfNonStochastic * this.valueIfNonStochastic;
            return new RandomVariable(this.time, d);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.realizations[i] * this.realizations[i];
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface sqrt() {
        if (this.isDeterministic()) {
            double d = Math.sqrt(this.valueIfNonStochastic);
            return new RandomVariable(this.time, d);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.sqrt(this.realizations[i]);
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariable exp() {
        if (this.isDeterministic()) {
            double d = FastMath.exp((double)this.valueIfNonStochastic);
            return new RandomVariable(this.time, d);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = FastMath.exp((double)this.realizations[i]);
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariable log() {
        if (this.isDeterministic()) {
            double d = FastMath.log((double)this.valueIfNonStochastic);
            return new RandomVariable(this.time, d);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = FastMath.log((double)this.realizations[i]);
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface sin() {
        if (this.isDeterministic()) {
            double d = FastMath.sin((double)this.valueIfNonStochastic);
            return new RandomVariable(this.time, d);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = FastMath.sin((double)this.realizations[i]);
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface cos() {
        if (this.isDeterministic()) {
            double d = FastMath.cos((double)this.valueIfNonStochastic);
            return new RandomVariable(this.time, d);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = FastMath.cos((double)this.realizations[i]);
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface add(RandomVariableInterface randomVariableInterface) {
        double d = Math.max(this.time, randomVariableInterface.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d2 = this.valueIfNonStochastic + randomVariableInterface.get(0);
            return new RandomVariable(d, d2);
        }
        if (this.isDeterministic()) {
            return randomVariableInterface.add(this);
        }
        double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.realizations[i] + randomVariableInterface.get(i);
        }
        return new RandomVariable(d, dArray);
    }

    @Override
    public RandomVariableInterface sub(RandomVariableInterface randomVariableInterface) {
        double d = Math.max(this.time, randomVariableInterface.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d2 = this.valueIfNonStochastic - randomVariableInterface.get(0);
            return new RandomVariable(d, d2);
        }
        if (this.isDeterministic()) {
            double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.valueIfNonStochastic - randomVariableInterface.get(i);
            }
            return new RandomVariable(d, dArray);
        }
        double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.realizations[i] - randomVariableInterface.get(i);
        }
        return new RandomVariable(d, dArray);
    }

    @Override
    public RandomVariableInterface mult(RandomVariableInterface randomVariableInterface) {
        double d = Math.max(this.time, randomVariableInterface.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d2 = this.valueIfNonStochastic * randomVariableInterface.get(0);
            return new RandomVariable(d, d2);
        }
        if (this.isDeterministic()) {
            double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.valueIfNonStochastic * randomVariableInterface.get(i);
            }
            return new RandomVariable(d, dArray);
        }
        double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.realizations[i] * randomVariableInterface.get(i);
        }
        return new RandomVariable(d, dArray);
    }

    @Override
    public RandomVariableInterface div(RandomVariableInterface randomVariableInterface) {
        double d = Math.max(this.time, randomVariableInterface.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d2 = this.valueIfNonStochastic / randomVariableInterface.get(0);
            return new RandomVariable(d, d2);
        }
        if (this.isDeterministic()) {
            double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.valueIfNonStochastic / randomVariableInterface.get(i);
            }
            return new RandomVariable(d, dArray);
        }
        double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.realizations[i] / randomVariableInterface.get(i);
        }
        return new RandomVariable(d, dArray);
    }

    @Override
    public RandomVariableInterface cap(RandomVariableInterface randomVariableInterface) {
        double d = Math.max(this.time, randomVariableInterface.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d2 = FastMath.min((double)this.valueIfNonStochastic, (double)randomVariableInterface.get(0));
            return new RandomVariable(d, d2);
        }
        if (this.isDeterministic()) {
            return randomVariableInterface.cap(this);
        }
        double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = FastMath.min((double)this.realizations[i], (double)randomVariableInterface.get(i));
        }
        return new RandomVariable(d, dArray);
    }

    @Override
    public RandomVariableInterface floor(RandomVariableInterface randomVariableInterface) {
        double d = Math.max(this.time, randomVariableInterface.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d2 = FastMath.max((double)this.valueIfNonStochastic, (double)randomVariableInterface.get(0));
            return new RandomVariable(d, d2);
        }
        if (this.isDeterministic()) {
            return randomVariableInterface.floor(this);
        }
        double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = FastMath.max((double)this.realizations[i], (double)randomVariableInterface.get(i));
        }
        return new RandomVariable(d, dArray);
    }

    @Override
    public RandomVariableInterface accrue(RandomVariableInterface randomVariableInterface, double d) {
        double d2 = Math.max(this.time, randomVariableInterface.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d3 = this.valueIfNonStochastic * (1.0 + randomVariableInterface.get(0) * d);
            return new RandomVariable(d2, d3);
        }
        if (this.isDeterministic() && !randomVariableInterface.isDeterministic()) {
            double[] dArray = randomVariableInterface.getRealizations();
            double[] dArray2 = new double[Math.max(this.size(), randomVariableInterface.size())];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = this.valueIfNonStochastic * (1.0 + dArray[i] * d);
            }
            return new RandomVariable(d2, dArray2);
        }
        if (!this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d4 = randomVariableInterface.get(0);
            double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.realizations[i] * (1.0 + d4 * d);
            }
            return new RandomVariable(d2, dArray);
        }
        double[] dArray = randomVariableInterface.getRealizations();
        double[] dArray3 = new double[Math.max(this.size(), randomVariableInterface.size())];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = this.realizations[i] * (1.0 + dArray[i] * d);
        }
        return new RandomVariable(d2, dArray3);
    }

    @Override
    public RandomVariableInterface discount(RandomVariableInterface randomVariableInterface, double d) {
        double d2 = Math.max(this.time, randomVariableInterface.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d3 = this.valueIfNonStochastic / (1.0 + randomVariableInterface.get(0) * d);
            return new RandomVariable(d2, d3);
        }
        if (this.isDeterministic() && !randomVariableInterface.isDeterministic()) {
            double[] dArray = randomVariableInterface.getRealizations();
            double[] dArray2 = new double[Math.max(this.size(), randomVariableInterface.size())];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = this.valueIfNonStochastic / (1.0 + dArray[i] * d);
            }
            return new RandomVariable(d2, dArray2);
        }
        if (!this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d4 = randomVariableInterface.get(0);
            double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.realizations[i] / (1.0 + d4 * d);
            }
            return new RandomVariable(d2, dArray);
        }
        double[] dArray = randomVariableInterface.getRealizations();
        double[] dArray3 = new double[Math.max(this.size(), randomVariableInterface.size())];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = this.realizations[i] / (1.0 + dArray[i] * d);
        }
        return new RandomVariable(d2, dArray3);
    }

    @Override
    public RandomVariableInterface barrier(RandomVariableInterface randomVariableInterface, RandomVariableInterface randomVariableInterface2, RandomVariableInterface randomVariableInterface3) {
        double d = Math.max(this.time, randomVariableInterface.getFiltrationTime());
        d = Math.max(d, randomVariableInterface2.getFiltrationTime());
        d = Math.max(d, randomVariableInterface3.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic() && randomVariableInterface2.isDeterministic() && randomVariableInterface3.isDeterministic()) {
            double d2 = randomVariableInterface.get(0) >= 0.0 ? randomVariableInterface2.get(0) : randomVariableInterface3.get(0);
            return new RandomVariable(d, d2);
        }
        int n = Math.max(Math.max(randomVariableInterface.size(), randomVariableInterface2.size()), randomVariableInterface3.size());
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = randomVariableInterface.get(i) >= 0.0 ? randomVariableInterface2.get(i) : randomVariableInterface3.get(i);
        }
        return new RandomVariable(d, dArray);
    }

    @Override
    public RandomVariableInterface barrier(RandomVariableInterface randomVariableInterface, RandomVariableInterface randomVariableInterface2, double d) {
        return this.barrier(randomVariableInterface, randomVariableInterface2, new RandomVariable(randomVariableInterface2.getFiltrationTime(), d));
    }

    @Override
    public RandomVariableInterface invert() {
        if (this.isDeterministic()) {
            double d = 1.0 / this.valueIfNonStochastic;
            return new RandomVariable(this.time, d);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 1.0 / this.realizations[i];
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface abs() {
        if (this.isDeterministic()) {
            double d = Math.abs(this.valueIfNonStochastic);
            return new RandomVariable(this.time, d);
        }
        double[] dArray = new double[this.realizations.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.abs(this.realizations[i]);
        }
        return new RandomVariable(this.time, dArray);
    }

    @Override
    public RandomVariableInterface addProduct(RandomVariableInterface randomVariableInterface, double d) {
        double d2 = Math.max(this.time, randomVariableInterface.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d3 = this.valueIfNonStochastic + randomVariableInterface.get(0) * d;
            return new RandomVariable(d2, d3);
        }
        if (this.isDeterministic() && !randomVariableInterface.isDeterministic()) {
            double[] dArray = randomVariableInterface.getRealizations();
            double[] dArray2 = new double[Math.max(this.size(), randomVariableInterface.size())];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = this.valueIfNonStochastic + dArray[i] * d;
            }
            return new RandomVariable(d2, dArray2);
        }
        if (!this.isDeterministic() && randomVariableInterface.isDeterministic()) {
            double d4 = randomVariableInterface.get(0);
            double[] dArray = new double[Math.max(this.size(), randomVariableInterface.size())];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.realizations[i] + d4 * d;
            }
            return new RandomVariable(d2, dArray);
        }
        double[] dArray = randomVariableInterface.getRealizations();
        double[] dArray3 = new double[Math.max(this.size(), randomVariableInterface.size())];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = this.realizations[i] + dArray[i] * d;
        }
        return new RandomVariable(d2, dArray3);
    }

    @Override
    public RandomVariableInterface addProduct(RandomVariableInterface randomVariableInterface, RandomVariableInterface randomVariableInterface2) {
        double d = Math.max(Math.max(this.time, randomVariableInterface.getFiltrationTime()), randomVariableInterface2.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic() && randomVariableInterface2.isDeterministic()) {
            double d2 = this.valueIfNonStochastic + randomVariableInterface.get(0) * randomVariableInterface2.get(0);
            return new RandomVariable(d, d2);
        }
        if (this.isDeterministic() && !randomVariableInterface.isDeterministic() && !randomVariableInterface2.isDeterministic()) {
            double[] dArray = randomVariableInterface.getRealizations();
            double[] dArray2 = randomVariableInterface2.getRealizations();
            double[] dArray3 = new double[Math.max(this.size(), randomVariableInterface.size())];
            for (int i = 0; i < dArray3.length; ++i) {
                dArray3[i] = this.valueIfNonStochastic + dArray[i] * dArray2[i];
            }
            return new RandomVariable(d, dArray3);
        }
        if (!(this.isDeterministic() || randomVariableInterface.isDeterministic() || randomVariableInterface2.isDeterministic())) {
            double[] dArray = randomVariableInterface.getRealizations();
            double[] dArray4 = randomVariableInterface2.getRealizations();
            double[] dArray5 = new double[Math.max(this.size(), randomVariableInterface.size())];
            for (int i = 0; i < dArray5.length; ++i) {
                dArray5[i] = this.realizations[i] + dArray[i] * dArray4[i];
            }
            return new RandomVariable(d, dArray5);
        }
        double[] dArray = new double[Math.max(Math.max(this.size(), randomVariableInterface.size()), randomVariableInterface2.size())];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.get(i) + randomVariableInterface.get(i) * randomVariableInterface2.get(i);
        }
        return new RandomVariable(d, dArray);
    }

    @Override
    public RandomVariableInterface addRatio(RandomVariableInterface randomVariableInterface, RandomVariableInterface randomVariableInterface2) {
        double d = Math.max(Math.max(this.time, randomVariableInterface.getFiltrationTime()), randomVariableInterface2.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic() && randomVariableInterface2.isDeterministic()) {
            double d2 = this.valueIfNonStochastic + randomVariableInterface.get(0) / randomVariableInterface2.get(0);
            return new RandomVariable(d, d2);
        }
        double[] dArray = new double[Math.max(Math.max(this.size(), randomVariableInterface.size()), randomVariableInterface2.size())];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.get(i) + randomVariableInterface.get(i) / randomVariableInterface2.get(i);
        }
        return new RandomVariable(d, dArray);
    }

    @Override
    public RandomVariableInterface subRatio(RandomVariableInterface randomVariableInterface, RandomVariableInterface randomVariableInterface2) {
        double d = Math.max(Math.max(this.time, randomVariableInterface.getFiltrationTime()), randomVariableInterface2.getFiltrationTime());
        if (this.isDeterministic() && randomVariableInterface.isDeterministic() && randomVariableInterface2.isDeterministic()) {
            double d2 = this.valueIfNonStochastic - randomVariableInterface.get(0) / randomVariableInterface2.get(0);
            return new RandomVariable(d, d2);
        }
        double[] dArray = new double[Math.max(Math.max(this.size(), randomVariableInterface.size()), randomVariableInterface2.size())];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.get(i) - randomVariableInterface.get(i) / randomVariableInterface2.get(i);
        }
        return new RandomVariable(d, dArray);
    }

    @Override
    public RandomVariableInterface isNaN() {
        if (this.isDeterministic()) {
            return new RandomVariable(this.time, Double.isNaN(this.valueIfNonStochastic) ? 1.0 : 0.0);
        }
        double[] dArray = new double[this.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.isNaN(this.get(i)) ? 1.0 : 0.0;
        }
        return new RandomVariable(this.time, dArray);
    }

    public String toString() {
        return super.toString() + "\n" + "time: " + this.time + "\n" + "realizations: " + (this.isDeterministic() ? Double.valueOf(this.valueIfNonStochastic) : Arrays.toString(this.realizations));
    }
}

