/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import cern.jet.random.engine.MersenneTwister64;
import java.io.Serializable;
import net.finmath.functions.GammaDistribution;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.IndependentIncrementsInterface;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class GammaProcess
implements IndependentIncrementsInterface,
Serializable {
    private static final long serialVersionUID = -5430067621669213475L;
    private final double shape;
    private final double scale;
    private final TimeDiscretizationInterface timeDiscretization;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private final int seed;
    private AbstractRandomVariableFactory randomVariableFactory = new RandomVariableFactory();
    private transient RandomVariableInterface[][] gammaIncrements;

    public GammaProcess(TimeDiscretizationInterface timeDiscretizationInterface, int n, int n2, int n3, double d, double d2) {
        this.timeDiscretization = timeDiscretizationInterface;
        this.numberOfFactors = n;
        this.numberOfPaths = n2;
        this.seed = n3;
        this.shape = d;
        this.scale = d2;
        this.gammaIncrements = null;
    }

    public GammaProcess(TimeDiscretizationInterface timeDiscretizationInterface, int n, int n2, int n3, double d) {
        this(timeDiscretizationInterface, n, n2, n3, d, 1.0);
    }

    @Override
    public IndependentIncrementsInterface getCloneWithModifiedSeed(int n) {
        return new GammaProcess(this.getTimeDiscretization(), this.getNumberOfFactors(), this.getNumberOfPaths(), n, this.shape);
    }

    @Override
    public IndependentIncrementsInterface getCloneWithModifiedTimeDiscretization(TimeDiscretizationInterface timeDiscretizationInterface) {
        return new GammaProcess(timeDiscretizationInterface, this.getNumberOfFactors(), this.getNumberOfPaths(), this.getSeed(), this.shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getIncrement(int n, int n2) {
        GammaProcess gammaProcess = this;
        synchronized (gammaProcess) {
            if (this.gammaIncrements == null) {
                this.doGenerateGammaIncrements();
            }
        }
        return this.gammaIncrements[n][n2];
    }

    private void doGenerateGammaIncrements() {
        int n;
        int n2;
        if (this.gammaIncrements != null) {
            return;
        }
        MersenneTwister64 mersenneTwister64 = new MersenneTwister64(this.seed);
        double[][][] dArray = new double[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors][this.numberOfPaths];
        GammaDistribution[] gammaDistributionArray = new GammaDistribution[this.timeDiscretization.getNumberOfTimeSteps()];
        for (n2 = 0; n2 < gammaDistributionArray.length; ++n2) {
            double d = this.timeDiscretization.getTimeStep(n2);
            gammaDistributionArray[n2] = new GammaDistribution(this.shape * d, this.scale);
        }
        for (n2 = 0; n2 < this.numberOfPaths; ++n2) {
            for (int i = 0; i < this.timeDiscretization.getNumberOfTimeSteps(); ++i) {
                GammaDistribution gammaDistribution = gammaDistributionArray[i];
                for (n = 0; n < this.numberOfFactors; ++n) {
                    double d = mersenneTwister64.nextDouble();
                    dArray[i][n][n2] = gammaDistribution.inverseCumulativeDistribution(d);
                }
            }
        }
        this.gammaIncrements = new RandomVariableInterface[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors];
        for (n2 = 0; n2 < this.timeDiscretization.getNumberOfTimeSteps(); ++n2) {
            double d = this.timeDiscretization.getTime(n2 + 1);
            for (n = 0; n < this.numberOfFactors; ++n) {
                this.gammaIncrements[n2][n] = this.randomVariableFactory.createRandomVariable(d, dArray[n2][n]);
            }
        }
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    @Override
    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double d) {
        return this.randomVariableFactory.createRandomVariable(d);
    }

    public int getSeed() {
        return this.seed;
    }

    public String toString() {
        return super.toString() + "\n" + "timeDiscretization: " + this.timeDiscretization.toString() + "\n" + "numberOfPaths: " + this.numberOfPaths + "\n" + "numberOfFactors: " + this.numberOfFactors + "\n" + "seed: " + this.seed + "\n" + "shape: " + this.shape;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GammaProcess gammaProcess = (GammaProcess)object;
        if (this.numberOfFactors != gammaProcess.numberOfFactors) {
            return false;
        }
        if (this.numberOfPaths != gammaProcess.numberOfPaths) {
            return false;
        }
        if (this.seed != gammaProcess.seed) {
            return false;
        }
        return this.timeDiscretization.equals(gammaProcess.timeDiscretization);
    }

    public int hashCode() {
        int n = this.timeDiscretization.hashCode();
        n = 31 * n + this.numberOfFactors;
        n = 31 * n + this.numberOfPaths;
        n = 31 * n + this.seed;
        n = 31 * n + new Double(this.shape).hashCode();
        return n;
    }
}

