/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class BrownianMotionView
implements BrownianMotionInterface {
    private BrownianMotionInterface brownianMotion;
    private Integer[] factors;

    public BrownianMotionView(BrownianMotionInterface brownianMotionInterface, Integer[] integerArray) {
        this.brownianMotion = brownianMotionInterface;
        this.factors = integerArray;
    }

    @Override
    public RandomVariableInterface getBrownianIncrement(int n, int n2) {
        return this.brownianMotion.getBrownianIncrement(n, this.factors[n2]);
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.brownianMotion.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.factors.length;
    }

    @Override
    public int getNumberOfPaths() {
        return this.brownianMotion.getNumberOfPaths();
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double d) {
        return this.brownianMotion.getRandomVariableForConstant(d);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedSeed(int n) {
        return new BrownianMotionView(this.brownianMotion.getCloneWithModifiedSeed(n), this.factors);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedTimeDiscretization(TimeDiscretizationInterface timeDiscretizationInterface) {
        return new BrownianMotionView(this.brownianMotion.getCloneWithModifiedTimeDiscretization(timeDiscretizationInterface), this.factors);
    }
}

