/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.modelling.ModelInterface;
import net.finmath.modelling.ProductInterface;
import net.finmath.montecarlo.MonteCarloSimulationInterface;
import net.finmath.stochastic.RandomVariableInterface;

public abstract class AbstractMonteCarloProduct
implements ProductInterface {
    private final String currency;

    public AbstractMonteCarloProduct(String string) {
        this.currency = string;
    }

    public AbstractMonteCarloProduct() {
        this(null);
    }

    @Override
    public Object getValue(double d, ModelInterface modelInterface) {
        throw new IllegalArgumentException("The product " + this.getClass() + " cannot be valued against a model " + modelInterface.getClass() + "." + "It requires a model of type " + AnalyticModelInterface.class + ".");
    }

    public abstract RandomVariableInterface getValue(double var1, MonteCarloSimulationInterface var3) throws CalculationException;

    public double getValue(MonteCarloSimulationInterface monteCarloSimulationInterface) throws CalculationException {
        return this.getValue(0.0, monteCarloSimulationInterface).getAverage();
    }

    public Map<String, Object> getValues(double d, MonteCarloSimulationInterface monteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = this.getValue(d, monteCarloSimulationInterface);
        if (randomVariableInterface == null) {
            return null;
        }
        double d2 = randomVariableInterface.getAverage();
        double d3 = randomVariableInterface.getStandardError();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("value", d2);
        hashMap.put("error", d3);
        return hashMap;
    }

    public Map<String, Object> getValuesForModifiedData(double d, MonteCarloSimulationInterface monteCarloSimulationInterface, Map<String, Object> map) throws CalculationException {
        MonteCarloSimulationInterface monteCarloSimulationInterface2 = monteCarloSimulationInterface.getCloneWithModifiedData(map);
        return this.getValues(d, monteCarloSimulationInterface2);
    }

    public Map<String, Object> getValuesForModifiedData(double d, MonteCarloSimulationInterface monteCarloSimulationInterface, String string, Object object) throws CalculationException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(string, object);
        return this.getValuesForModifiedData(d, monteCarloSimulationInterface, hashMap);
    }

    public Map<String, Object> getValues(MonteCarloSimulationInterface monteCarloSimulationInterface) throws CalculationException {
        return this.getValues(0.0, monteCarloSimulationInterface);
    }

    public Map<String, Object> getValuesForModifiedData(MonteCarloSimulationInterface monteCarloSimulationInterface, Map<String, Object> map) throws CalculationException {
        return this.getValuesForModifiedData(0.0, monteCarloSimulationInterface, map);
    }

    public Map<String, Object> getValuesForModifiedData(MonteCarloSimulationInterface monteCarloSimulationInterface, String string, Object object) throws CalculationException {
        return this.getValuesForModifiedData(0.0, monteCarloSimulationInterface, string, object);
    }

    public String getCurrency() {
        return this.currency;
    }

    public String toString() {
        return "AbstractMonteCarloProduct [currency=" + this.currency + "]";
    }
}

