/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.time.ScheduleInterface;

public class SwapLeg
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final ScheduleInterface legSchedule;
    private final String forwardCurveName;
    private final double spread;
    private final String discountCurveName;
    private boolean isNotionalExchanged = false;

    public SwapLeg(ScheduleInterface scheduleInterface, String string, double d, String string2, boolean bl) {
        this.legSchedule = scheduleInterface;
        this.forwardCurveName = string;
        this.spread = d;
        this.discountCurveName = string2;
        this.isNotionalExchanged = bl;
    }

    public SwapLeg(ScheduleInterface scheduleInterface, String string, double d, String string2) {
        this(scheduleInterface, string, d, string2, false);
    }

    @Override
    public double getValue(double d, AnalyticModelInterface analyticModelInterface) {
        ForwardCurveInterface forwardCurveInterface = analyticModelInterface.getForwardCurve(this.forwardCurveName);
        DiscountCurveInterface discountCurveInterface = analyticModelInterface.getDiscountCurve(this.discountCurveName);
        DiscountCurveInterface discountCurveInterface2 = null;
        if (forwardCurveInterface == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0 && (discountCurveInterface2 = analyticModelInterface.getDiscountCurve(this.forwardCurveName)) == null) {
            throw new IllegalArgumentException("No curve of the name " + this.forwardCurveName + " was found in the model.");
        }
        double d2 = 0.0;
        for (int i = 0; i < this.legSchedule.getNumberOfPeriods(); ++i) {
            double d3 = this.legSchedule.getFixing(i);
            double d4 = this.legSchedule.getPayment(i);
            double d5 = this.legSchedule.getPeriodLength(i);
            if (d5 == 0.0) continue;
            double d6 = this.spread;
            if (forwardCurveInterface != null) {
                d6 += forwardCurveInterface.getForward(analyticModelInterface, d3, d4 - d3);
            } else if (discountCurveInterface2 != null && d3 != d4) {
                d6 += (discountCurveInterface2.getDiscountFactor(d3) / discountCurveInterface2.getDiscountFactor(d4) - 1.0) / (d4 - d3);
            }
            if (discountCurveInterface == null) {
                throw new IllegalArgumentException("No curve of the name " + this.discountCurveName + " was found in the model.");
            }
            double d7 = d4 > d ? discountCurveInterface.getDiscountFactor(analyticModelInterface, d4) : 0.0;
            d2 += d6 * d5 * d7;
            if (!this.isNotionalExchanged) continue;
            double d8 = this.legSchedule.getPeriodEnd(i);
            d2 += d8 > d ? discountCurveInterface.getDiscountFactor(analyticModelInterface, d8) : 0.0;
            double d9 = this.legSchedule.getPeriodStart(i);
            d2 -= d9 > d ? discountCurveInterface.getDiscountFactor(analyticModelInterface, d9) : 0.0;
        }
        return d2 / discountCurveInterface.getDiscountFactor(analyticModelInterface, d);
    }

    public ScheduleInterface getSchedule() {
        return this.legSchedule;
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public double getSpread() {
        return this.spread;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public boolean isNotionalExchanged() {
        return this.isNotionalExchanged;
    }

    public String toString() {
        return "SwapLeg [legSchedule=" + this.legSchedule + ", forwardCurveName=" + this.forwardCurveName + ", spread=" + this.spread + ", discountCurveName=" + this.discountCurveName + ", isNotionalExchanged=" + this.isNotionalExchanged + "]";
    }
}

