/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.AbstractSwaptionMarketData;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class SwaptionMarketData
implements AbstractSwaptionMarketData {
    private final ForwardCurveInterface forwardCurve;
    private final DiscountCurveInterface discountCurve;
    private final TimeDiscretizationInterface optionMaturities;
    private final TimeDiscretizationInterface tenor;
    private final double swapPeriodLength;
    private final double[][] impliedVolatilities;

    public SwaptionMarketData(double[] dArray, double[] dArray2, double d, double[][] dArray3) {
        this.forwardCurve = null;
        this.discountCurve = null;
        this.optionMaturities = new TimeDiscretization(dArray);
        this.tenor = new TimeDiscretization(dArray2);
        this.swapPeriodLength = d;
        this.impliedVolatilities = dArray3;
    }

    public SwaptionMarketData(ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface, double[] dArray, double[] dArray2, double d, double[][] dArray3) {
        this.forwardCurve = forwardCurveInterface;
        this.discountCurve = discountCurveInterface;
        this.optionMaturities = new TimeDiscretization(dArray);
        this.tenor = new TimeDiscretization(dArray2);
        this.swapPeriodLength = d;
        this.impliedVolatilities = dArray3;
    }

    public SwaptionMarketData(ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface, TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, double d, double[][] dArray) {
        this.forwardCurve = forwardCurveInterface;
        this.discountCurve = discountCurveInterface;
        this.optionMaturities = timeDiscretizationInterface;
        this.tenor = timeDiscretizationInterface2;
        this.swapPeriodLength = d;
        this.impliedVolatilities = dArray;
    }

    @Override
    public TimeDiscretizationInterface getOptionMaturities() {
        return this.optionMaturities;
    }

    @Override
    public TimeDiscretizationInterface getTenor() {
        return this.tenor;
    }

    @Override
    public double getSwapPeriodLength() {
        return this.swapPeriodLength;
    }

    @Override
    public double getValue(double d, double d2, double d3, double d4) {
        throw new RuntimeException("Method not implemented.");
    }

    public double getVolatility(double d, double d2) {
        int n = this.optionMaturities.getTimeIndex(d);
        int n2 = this.tenor.getTimeIndex(d2);
        if (n < 0) {
            throw new IllegalArgumentException("Option maturity not part of data.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Tenor maturity not part of data.");
        }
        return this.impliedVolatilities[n][n2];
    }

    @Override
    public double getVolatility(double d, double d2, double d3, double d4) {
        int n = this.optionMaturities.getTimeIndex(d);
        int n2 = this.tenor.getTimeIndex(d2);
        if (n < 0) {
            throw new IllegalArgumentException("Option maturity not part of data.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Tenor maturity not part of data.");
        }
        return this.impliedVolatilities[n][n2];
    }
}

