/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.util.Calendar;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurfaceParametric;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;

public class CapletVolatilitiesParametric
extends AbstractVolatilitySurfaceParametric {
    private final double timeScaling;
    private final double a;
    private final double b;
    private final double c;
    private final double d;

    public CapletVolatilitiesParametric(String string, Calendar calendar, double d, double d2, double d3, double d4, double d5) {
        super(string, calendar);
        this.timeScaling = d5;
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.quotingConvention = VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL;
    }

    public CapletVolatilitiesParametric(String string, Calendar calendar, double d, double d2, double d3, double d4) {
        this(string, calendar, d, d2, d3, d4, 1.0);
    }

    @Override
    public double getValue(double d, double d2, VolatilitySurfaceInterface.QuotingConvention quotingConvention) {
        return this.getValue(null, d, d2, quotingConvention);
    }

    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d, double d2, VolatilitySurfaceInterface.QuotingConvention quotingConvention) {
        if (d == 0.0) {
            return 0.0;
        }
        double d3 = d * this.timeScaling;
        double d4 = this.c != 0.0 ? this.a * this.a * d3 * ((1.0 - Math.exp(-2.0 * this.c * d3)) / (2.0 * this.c * d3)) + this.a * this.b * d3 * d3 * (((1.0 - Math.exp(-2.0 * this.c * d3)) / (2.0 * this.c * d3) - Math.exp(-2.0 * this.c * d3)) / (this.c * d3)) + 2.0 * this.a * this.d * d3 * ((1.0 - Math.exp(-this.c * d3)) / (this.c * d3)) + this.b * this.b * d3 * d3 * d3 * ((((1.0 - Math.exp(-2.0 * this.c * d3)) / (2.0 * this.c * d3) - Math.exp(-2.0 * this.c * d3)) / (d3 * this.c) - Math.exp(-2.0 * this.c * d3)) / (2.0 * this.c * d3)) + 2.0 * this.b * this.d * d3 * d3 * ((1.0 - Math.exp(-this.c * d3) - d3 * this.c * Math.exp(-this.c * d3)) / (this.c * this.c * d3 * d3)) + this.d * this.d * d3 : this.a * this.a * d3 + this.a * this.b * d3 * d3 + 2.0 * this.a * this.d * d3 + this.b * this.b * d3 * d3 * d3 / 3.0 + this.b * this.d * d3 * d3 + this.d * this.d * d3;
        double d5 = Math.sqrt(d4 / d);
        return this.convertFromTo(analyticModelInterface, d, d2, d5, this.quotingConvention, quotingConvention);
    }

    @Override
    public double[] getParameter() {
        double[] dArray = new double[]{this.a, this.b, this.c, this.d};
        return dArray;
    }

    @Override
    public void setParameter(double[] dArray) {
        throw new UnsupportedOperationException("This class is immutable.");
    }

    @Override
    public AbstractVolatilitySurfaceParametric getCloneForParameter(double[] dArray) throws CloneNotSupportedException {
        return new CapletVolatilitiesParametric(this.getName(), this.getReferenceDate(), dArray[0], dArray[1], dArray[2], dArray[3], this.timeScaling);
    }
}

