/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.util.Calendar;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.CurveInterface;

public class PiecewiseCurve
extends AbstractCurve
implements CurveInterface {
    private CurveInterface baseCurve;
    private CurveInterface fixedPartCurve;
    private double fixedPartStartTime;
    private double fixedPartEndTime;

    public PiecewiseCurve(CurveInterface curveInterface, CurveInterface curveInterface2, double d, double d2) {
        super(curveInterface.getName(), curveInterface.getReferenceDate());
        this.baseCurve = curveInterface;
        this.fixedPartCurve = curveInterface2;
        this.fixedPartStartTime = d;
        this.fixedPartEndTime = d2;
    }

    @Override
    public double[] getParameter() {
        return this.baseCurve.getParameter();
    }

    @Override
    public void setParameter(double[] dArray) {
        this.baseCurve.setParameter(dArray);
    }

    @Override
    public String getName() {
        return this.baseCurve.getName();
    }

    @Override
    public Calendar getReferenceDate() {
        return this.baseCurve.getReferenceDate();
    }

    public CurveInterface getBaseCurve() {
        return this.baseCurve;
    }

    public CurveInterface getFixedPartCurve() {
        return this.fixedPartCurve;
    }

    public double getFixedPartStartTime() {
        return this.fixedPartStartTime;
    }

    public double getFixedPartEndTime() {
        return this.fixedPartEndTime;
    }

    @Override
    public double getValue(double d) {
        return this.getValue(null, d);
    }

    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d) {
        if (d > this.fixedPartStartTime && d < this.fixedPartEndTime) {
            return this.fixedPartCurve.getValue(analyticModelInterface, d);
        }
        return this.baseCurve.getValue(analyticModelInterface, d);
    }

    @Override
    public CurveInterface getCloneForParameter(double[] dArray) throws CloneNotSupportedException {
        PiecewiseCurve piecewiseCurve = this.clone();
        piecewiseCurve.baseCurve = this.baseCurve.getCloneForParameter(dArray);
        return piecewiseCurve;
    }

    @Override
    public PiecewiseCurve clone() throws CloneNotSupportedException {
        return new PiecewiseCurve((CurveInterface)this.baseCurve.clone(), this.fixedPartCurve, this.fixedPartStartTime, this.fixedPartEndTime);
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        return new CurveBuilder(this);
    }

    @Override
    public String toString() {
        return "ForwardCurveWithFixings [getBaseCurve()=" + this.getBaseCurve() + ", getFixedPartCurve()=" + this.getFixedPartCurve() + ", getFixedPartStartTime()=" + this.getFixedPartStartTime() + ", getFixedPartEndTime()=" + this.getFixedPartEndTime() + ", toString()=" + super.toString() + "]";
    }

    public static class CurveBuilder
    extends Curve.CurveBuilder
    implements CurveBuilderInterface {
        private PiecewiseCurve curve = null;

        public CurveBuilder(PiecewiseCurve piecewiseCurve) throws CloneNotSupportedException {
            super((Curve)piecewiseCurve.baseCurve);
            this.curve = piecewiseCurve;
        }

        @Override
        public CurveInterface build() throws CloneNotSupportedException {
            PiecewiseCurve piecewiseCurve = this.curve.clone();
            piecewiseCurve.baseCurve = super.build();
            this.curve = null;
            return piecewiseCurve;
        }
    }
}

