/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import org.apache.commons.math3.util.FastMath;

public class DiscountCurveNelsonSiegelSvensson
extends AbstractCurve
implements Serializable,
DiscountCurveInterface {
    private static final long serialVersionUID = 8024640795839972709L;
    private final double timeScaling;
    private final double[] parameter;

    public DiscountCurveNelsonSiegelSvensson(String string, Calendar calendar, double[] dArray, double d) {
        super(string, calendar);
        this.timeScaling = d;
        this.parameter = (double[])dArray.clone();
    }

    @Override
    public double getDiscountFactor(double d) {
        return this.getDiscountFactor(null, d);
    }

    @Override
    public double getDiscountFactor(AnalyticModelInterface analyticModelInterface, double d) {
        double d2;
        double d3;
        d *= this.timeScaling;
        double d4 = this.parameter[0];
        double d5 = this.parameter[1];
        double d6 = this.parameter[2];
        double d7 = this.parameter[3];
        double d8 = this.parameter[4];
        double d9 = this.parameter[5];
        double d10 = d8 > 0.0 ? FastMath.exp((double)(-d / d8)) : 0.0;
        double d11 = d3 = d9 > 0.0 ? FastMath.exp((double)(-d / d9)) : 0.0;
        double d12 = d8 > 0.0 ? (d > 0.0 ? (1.0 - d10) / d * d8 : 1.0) : (d2 = 0.0);
        double d13 = d9 > 0.0 ? (d > 0.0 ? (1.0 - d3) / d * d9 : 1.0) : 0.0;
        double d14 = d4 + d5 * d2 + d6 * (d2 - d10) + d7 * (d13 - d3);
        return Math.exp(-d14 * d);
    }

    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d) {
        return this.getDiscountFactor(analyticModelInterface, d);
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        return null;
    }

    @Override
    public double[] getParameter() {
        return this.parameter;
    }

    @Override
    @Deprecated
    public void setParameter(double[] dArray) {
        throw new UnsupportedOperationException();
    }

    public double getTimeScaling() {
        return this.timeScaling;
    }

    @Override
    public DiscountCurveNelsonSiegelSvensson clone() throws CloneNotSupportedException {
        return (DiscountCurveNelsonSiegelSvensson)super.clone();
    }

    @Override
    public DiscountCurveNelsonSiegelSvensson getCloneForParameter(double[] dArray) throws CloneNotSupportedException {
        return new DiscountCurveNelsonSiegelSvensson(this.getName(), this.getReferenceDate(), dArray, this.timeScaling);
    }

    @Override
    public String toString() {
        return "DiscountCurveNelsonSiegelSvensson [timeScaling=" + this.timeScaling + ", parameter=" + Arrays.toString(this.parameter) + ", toString()=" + super.toString() + "]";
    }
}

