/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.util.Calendar;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class DiscountCurve
extends Curve
implements Serializable,
DiscountCurveInterface {
    private static final long serialVersionUID = -4126228588123963885L;

    private DiscountCurve(String string) {
        super(string, null, Curve.InterpolationMethod.LINEAR, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.LOG_OF_VALUE_PER_TIME);
    }

    private DiscountCurve(String string, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        super(string, null, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    private DiscountCurve(String string, Calendar calendar, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        super(string, calendar, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromDiscountFactors(String string, Calendar calendar, double[] dArray, double[] dArray2, boolean[] blArray, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        DiscountCurve discountCurve = new DiscountCurve(string, calendar, interpolationMethod, extrapolationMethod, interpolationEntity);
        for (int i = 0; i < dArray.length; ++i) {
            discountCurve.addDiscountFactor(dArray[i], dArray2[i], blArray != null && blArray[i]);
        }
        return discountCurve;
    }

    public static DiscountCurve createDiscountCurveFromDiscountFactors(String string, double[] dArray, double[] dArray2, boolean[] blArray, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        return DiscountCurve.createDiscountCurveFromDiscountFactors(string, null, dArray, dArray2, blArray, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromDiscountFactors(String string, double[] dArray, double[] dArray2, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        boolean[] blArray = new boolean[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            blArray[i] = dArray[i] > 0.0;
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(string, dArray, dArray2, blArray, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromDiscountFactors(String string, double[] dArray, double[] dArray2) {
        DiscountCurve discountCurve = new DiscountCurve(string);
        for (int i = 0; i < dArray.length; ++i) {
            discountCurve.addDiscountFactor(dArray[i], dArray2[i], dArray[i] > 0.0);
        }
        return discountCurve;
    }

    public static DiscountCurve createDiscountCurveFromZeroRates(String string, Calendar calendar, double[] dArray, double[] dArray2, boolean[] blArray, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = Math.exp(-dArray2[i] * dArray[i]);
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(string, calendar, dArray, dArray3, blArray, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromZeroRates(String string, double[] dArray, double[] dArray2, boolean[] blArray, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        return DiscountCurve.createDiscountCurveFromZeroRates(string, null, dArray, dArray2, blArray, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromZeroRates(String string, Calendar calendar, double[] dArray, double[] dArray2, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        double[] dArray3 = new double[dArray2.length];
        boolean[] blArray = new boolean[dArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = Math.exp(-dArray2[i] * dArray[i]);
            blArray[i] = false;
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(string, calendar, dArray, dArray3, blArray, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromZeroRates(String string, double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = Math.exp(-dArray2[i] * dArray[i]);
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(string, dArray, dArray3);
    }

    public static DiscountCurve createDiscountCurveFromAnnualizedZeroRates(String string, Calendar calendar, double[] dArray, double[] dArray2, boolean[] blArray, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = Math.pow(1.0 + dArray2[i], -dArray[i]);
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(string, calendar, dArray, dArray3, blArray, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromAnnualizedZeroRates(String string, Calendar calendar, double[] dArray, double[] dArray2, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        double[] dArray3 = new double[dArray2.length];
        boolean[] blArray = new boolean[dArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = Math.pow(1.0 + dArray2[i], -dArray[i]);
            blArray[i] = false;
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(string, calendar, dArray, dArray3, blArray, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterface createDiscountFactorsFromForwardRates(String string, TimeDiscretizationInterface timeDiscretizationInterface, double[] dArray) {
        DiscountCurve discountCurve = new DiscountCurve(string);
        double d = 1.0;
        for (int i = 0; i < timeDiscretizationInterface.getNumberOfTimeSteps(); ++i) {
            discountCurve.addDiscountFactor(timeDiscretizationInterface.getTime(i + 1), d /= 1.0 + dArray[i] * timeDiscretizationInterface.getTimeStep(i), timeDiscretizationInterface.getTime(i + 1) > 0.0);
        }
        return discountCurve;
    }

    @Override
    public double getDiscountFactor(double d) {
        return this.getDiscountFactor(null, d);
    }

    @Override
    public double getDiscountFactor(AnalyticModelInterface analyticModelInterface, double d) {
        return this.getValue(analyticModelInterface, d);
    }

    public double getZeroRate(double d) {
        if (d == 0.0) {
            return this.getZeroRate(1.0E-14);
        }
        return -Math.log(this.getDiscountFactor(null, d)) / d;
    }

    public double[] getZeroRates(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = this.getZeroRate(dArray[i]);
        }
        return dArray2;
    }

    protected void addDiscountFactor(double d, double d2, boolean bl) {
        this.addPoint(d, d2, bl);
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

