/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.integration;

import cern.jet.random.engine.MersenneTwister64;
import net.finmath.compatibility.java.util.function.DoubleUnaryOperator;
import net.finmath.integration.AbstractRealIntegral;

public class MonteCarloIntegrator
extends AbstractRealIntegral {
    private int numberOfEvaluationPoints;
    private int seed = 3141;

    public MonteCarloIntegrator(double d, double d2, int n, boolean bl) {
        super(d, d2);
        if (n < 3) {
            throw new IllegalArgumentException("Invalid numberOfEvaluationPoints.");
        }
        this.numberOfEvaluationPoints = n;
    }

    public MonteCarloIntegrator(double d, double d2, int n) {
        this(d, d2, n, false);
    }

    @Override
    public double integrate(DoubleUnaryOperator doubleUnaryOperator) {
        double d = this.getLowerBound();
        double d2 = this.getUpperBound();
        double d3 = d2 - d;
        MersenneTwister64 mersenneTwister64 = new MersenneTwister64(this.seed);
        double d4 = 0.0;
        for (int i = 0; i < this.numberOfEvaluationPoints; ++i) {
            d4 += doubleUnaryOperator.applyAsDouble(d + mersenneTwister64.nextDouble() * d3);
        }
        return d4 * d3 / (double)this.numberOfEvaluationPoints;
    }
}

