/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.products;

import net.finmath.fouriermethod.products.AbstractProductFourierTransform;
import org.apache.commons.math3.complex.Complex;

public class EuropeanOption
extends AbstractProductFourierTransform {
    private final double maturity;
    private final double strike;
    private final String nameOfUnderliyng;

    public EuropeanOption(double d, double d2) {
        this.maturity = d;
        this.strike = d2;
        this.nameOfUnderliyng = null;
    }

    @Override
    public Complex apply(Complex complex) {
        Complex complex2 = complex.multiply(Complex.I);
        Complex complex3 = complex2.add(1.0);
        Complex complex4 = new Complex(this.strike).pow(complex3);
        Complex complex5 = complex.multiply(complex).subtract(complex2);
        return complex4.divide(complex5).negate();
    }

    @Override
    public double getMaturity() {
        return this.maturity;
    }

    @Override
    public double getIntegrationDomainImagLowerBound() {
        return 0.5;
    }

    @Override
    public double getIntegrationDomainImagUpperBound() {
        return 2.5;
    }
}

