/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.layers.layer3.engine;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.Release;
import org.neodatis.odb.core.layers.layer3.IOSocketParameter;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.server.connection.ClientServerConnection;
import org.neodatis.odb.core.server.connection.ConnectionManager;
import org.neodatis.odb.core.server.connection.DefaultConnectionThread;
import org.neodatis.odb.core.server.layers.layer3.IODBServerExt;
import org.neodatis.odb.core.server.layers.layer3.ServerFileParameter;
import org.neodatis.odb.core.server.layers.layer3.engine.IServerStorageEngine;
import org.neodatis.odb.core.server.trigger.ServerDeleteTrigger;
import org.neodatis.odb.core.server.trigger.ServerInsertTrigger;
import org.neodatis.odb.core.server.trigger.ServerSelectTrigger;
import org.neodatis.odb.core.server.trigger.ServerUpdateTrigger;
import org.neodatis.odb.core.trigger.OIDTrigger;
import org.neodatis.odb.impl.main.SameVMODBClient;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbRunnable;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class ODBServerImpl
implements OdbRunnable,
IODBServerExt {
    public static final String LOG_ID = "ODBServer";
    private int port;
    private OdbThread thread;
    private boolean serverIsUp;
    private ServerSocket socketServer;
    private boolean isRunning;
    private Map<String, IServerStorageEngine> bases;
    private Map<String, ConnectionManager> connectionManagers;
    private boolean automaticallyCreateDatabase;
    private long start;

    public ODBServerImpl(int port) {
        OdbConfiguration.setCheckModelCompatibility(true);
        this.port = port;
        this.automaticallyCreateDatabase = true;
        this.initServer();
    }

    private void initServer() {
        this.bases = new OdbHashMap<String, IServerStorageEngine>();
        this.connectionManagers = new OdbHashMap<String, ConnectionManager>();
        try {
            this.socketServer = new ServerSocket(this.port);
            this.isRunning = true;
        }
        catch (BindException e1) {
            this.isRunning = false;
            throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_PORT_IS_BUSY.addParameter(this.port), (Throwable)e1);
        }
        catch (IOException e2) {
            this.isRunning = false;
            throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_CAN_NOT_OPEN_ODB_SERVER_ON_PORT.addParameter(this.port), (Throwable)e2);
        }
    }

    @Override
    public void addBase(String baseIdentifier, String fileName) {
        this.addBase(baseIdentifier, fileName, null, null);
    }

    @Override
    public void addBase(String baseIdentifier, String fileName, String user, String password) {
        ServerFileParameter fileParameter = new ServerFileParameter(baseIdentifier, fileName, true, user, password);
        IServerStorageEngine engine = null;
        engine = OdbConfiguration.getCoreProvider().getServerStorageEngine(fileParameter);
        engine.commit();
        this.bases.put(baseIdentifier, engine);
        this.connectionManagers.put(baseIdentifier, new ConnectionManager(engine));
        if (OdbConfiguration.isInfoEnabled(LOG_ID)) {
            DLogger.info("ODBServer:Adding base : name=" + baseIdentifier + " (file=" + fileName + ") to server");
        }
    }

    @Override
    public void addUserForBase(String baseIdentifier, String user, String password) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }

    @Override
    public void startServer(boolean inThread) {
        if (inThread) {
            this.thread = new OdbThread(this);
            this.thread.start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        try {
            this.startServer();
        }
        catch (IOException e) {
            DLogger.error(OdbString.exceptionToString(e, true));
        }
    }

    public void startServer() throws IOException {
        this.start = OdbTime.getCurrentTimeInMs();
        if (OdbConfiguration.logServerStartupAndShutdown()) {
            DLogger.info("NeoDatis ODB Server [version=" + Release.RELEASE_NUMBER + " - build=" + Release.RELEASE_BUILD + "-" + Release.RELEASE_DATE + "] running on port " + this.port);
            if (this.bases.size() != 0) {
                DLogger.info("Managed bases: " + this.bases.keySet());
            }
        }
        while (this.isRunning) {
            try {
                this.waitForRemoteConnection();
            }
            catch (SocketException e) {
                if (!this.isRunning) continue;
                DLogger.error("ODBServer:ODBServerImpl.startServer:" + OdbString.exceptionToString(e, true));
            }
        }
    }

    public ClientServerConnection waitForRemoteConnection() throws IOException {
        Socket connection = this.socketServer.accept();
        connection.setTcpNoDelay(true);
        DefaultConnectionThread connectionThread = new DefaultConnectionThread(this, connection, this.automaticallyCreateDatabase);
        OdbThread thread = new OdbThread(connectionThread);
        connectionThread.setName(thread.getName());
        thread.start();
        return connectionThread;
    }

    @Override
    public void close() {
        if (OdbConfiguration.logServerStartupAndShutdown()) {
            long end = OdbTime.getCurrentTimeInMs();
            double timeInHour = (double)(end - this.start) / 1000.0 / 60.0 / 60.0;
            DLogger.info(String.format("NeoDatis ODB Server (port %d) shutdown [uptime=%dHours]", this.port, (long)timeInHour));
        }
        try {
            this.isRunning = false;
            this.socketServer.close();
            Iterator<String> iterator = this.bases.keySet().iterator();
            String baseIdentifier = null;
            IStorageEngine engine = null;
            while (iterator.hasNext()) {
                baseIdentifier = iterator.next();
                engine = this.bases.get(baseIdentifier);
                if (OdbConfiguration.isInfoEnabled(LOG_ID)) {
                    DLogger.info("Closing Base " + baseIdentifier);
                }
                if (engine == null || engine.isClosed()) continue;
                engine.close();
            }
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_ERROR.addParameter("While closing server"), (Throwable)e);
        }
    }

    @Override
    public void setAutomaticallyCreateDatabase(boolean yes) {
        this.automaticallyCreateDatabase = yes;
    }

    @Override
    public ODB openClient(String baseIdentifier) {
        return new SameVMODBClient(this, baseIdentifier);
    }

    @Override
    public Map getConnectionManagers() {
        return this.connectionManagers;
    }

    @Override
    public IOSocketParameter getParameters(String baseIdentifier, boolean clientAndServerRunInSameVM) {
        return new IOSocketParameter("localhost", this.port, baseIdentifier, 1, OdbTime.getCurrentTimeInMs(), null, null, clientAndServerRunInSameVM);
    }

    @Override
    public void addDeleteTrigger(String baseIdentifier, String className, ServerDeleteTrigger trigger) {
        IServerStorageEngine engine = this.bases.get(baseIdentifier);
        if (engine == null) {
            throw new ODBRuntimeException(NeoDatisError.UNREGISTERED_BASE_ON_SERVER.addParameter(baseIdentifier));
        }
        engine.addDeleteTriggerFor(className, trigger);
    }

    @Override
    public void addInsertTrigger(String baseIdentifier, String className, ServerInsertTrigger trigger) {
        IServerStorageEngine engine = this.bases.get(baseIdentifier);
        if (engine == null) {
            throw new ODBRuntimeException(NeoDatisError.UNREGISTERED_BASE_ON_SERVER.addParameter(baseIdentifier));
        }
        engine.addInsertTriggerFor(className, trigger);
    }

    @Override
    public void addOidTrigger(String baseIdentifier, String className, OIDTrigger trigger) {
        IServerStorageEngine engine = this.bases.get(baseIdentifier);
        if (engine == null) {
            throw new ODBRuntimeException(NeoDatisError.UNREGISTERED_BASE_ON_SERVER.addParameter(baseIdentifier));
        }
        engine.addOidTriggerFor(className, trigger);
    }

    @Override
    public void addSelectTrigger(String baseIdentifier, String className, ServerSelectTrigger trigger) {
        IServerStorageEngine engine = this.bases.get(baseIdentifier);
        if (engine == null) {
            throw new ODBRuntimeException(NeoDatisError.UNREGISTERED_BASE_ON_SERVER.addParameter(baseIdentifier));
        }
        engine.addSelectTriggerFor(className, trigger);
    }

    @Override
    public void addUpdateTrigger(String baseIdentifier, String className, ServerUpdateTrigger trigger) {
        IServerStorageEngine engine = this.bases.get(baseIdentifier);
        if (engine == null) {
            throw new ODBRuntimeException(NeoDatisError.UNREGISTERED_BASE_ON_SERVER.addParameter(baseIdentifier));
        }
        engine.addUpdateTriggerFor(className, trigger);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        Set<String> baseIds = this.connectionManagers.keySet();
        b.append(String.format("%d connection managers", this.connectionManagers.size()));
        Iterator<String> iterator = baseIds.iterator();
        while (iterator.hasNext()) {
            ConnectionManager cm = this.connectionManagers.get(iterator.next());
            b.append(String.format("\n\t%s : %s sessions", cm.getStorageEngine().getBaseIdentification().getIdentification(), cm.getNbConnections()));
        }
        return b.toString();
    }
}

