/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.values;

import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.execution.GenericQueryExecutor;
import org.neodatis.odb.core.query.execution.IQueryExecutionPlan;
import org.neodatis.odb.core.query.execution.IndexTool;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQueryExecutionPlan;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQueryManager;
import org.neodatis.tool.wrappers.list.IOdbList;

public class ValuesCriteriaQueryExecutor
extends GenericQueryExecutor {
    private IOdbList<String> involvedFields;
    private CriteriaQuery criteriaQuery;
    private AttributeValuesMap values;
    private CriteriaQueryManager manager;

    public ValuesCriteriaQueryExecutor(IQuery query, IStorageEngine engine) {
        super(query, engine);
        this.criteriaQuery = (CriteriaQuery)query;
        this.manager = new CriteriaQueryManager();
    }

    @Override
    public IQueryExecutionPlan getExecutionPlan() {
        CriteriaQueryExecutionPlan plan = new CriteriaQueryExecutionPlan(this.classInfo, (CriteriaQuery)this.query);
        return plan;
    }

    @Override
    public void prepareQuery() {
        this.criteriaQuery = (CriteriaQuery)this.query;
        this.criteriaQuery.setStorageEngine(this.storageEngine);
        this.involvedFields = this.criteriaQuery.getAllInvolvedFields();
    }

    @Override
    public boolean matchObjectWithOid(OID oid, boolean returnObject, boolean inMemory) {
        this.currentOid = oid;
        boolean optimizeObjectCompararison = this.criteriaQuery.optimizeObjectComparison();
        this.values = this.objectReader.readObjectInfoValuesFromOID(this.classInfo, this.currentOid, true, this.involvedFields, this.involvedFields, 0, this.criteriaQuery.getOrderByFieldNames(), optimizeObjectCompararison);
        boolean objectMatches = true;
        if (!this.criteriaQuery.isForSingleOid()) {
            objectMatches = this.manager.match(this.criteriaQuery, this.values);
        }
        ObjectInfoHeader oih = this.values.getObjectInfoHeader();
        this.nextOID = oih.getNextObjectOID();
        return objectMatches;
    }

    @Override
    public Comparable computeIndexKey(ClassInfo ci, ClassInfoIndex index) {
        return IndexTool.computeKey(this.classInfo, index, (CriteriaQuery)this.query);
    }

    @Override
    public Object getCurrentObjectMetaRepresentation() {
        return this.values;
    }

    @Override
    public String getFullClassName(IQuery query) {
        return this.manager.getFullClassName((CriteriaQuery)query);
    }
}

