/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.list.objects;

import java.util.Iterator;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.impl.multiplevalue.InMemoryBTreeMultipleValuesPerKey;
import org.neodatis.odb.core.OrderByConstants;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.impl.core.btree.LazyODBBTreeIteratorMultiple;
import org.neodatis.odb.impl.core.query.list.objects.AbstractBTreeCollection;

public class LazyBTreeCollection<T>
extends AbstractBTreeCollection<T> {
    private IStorageEngine storageEngine;
    private boolean returnObjects;

    public LazyBTreeCollection(int size, IStorageEngine engine, boolean returnObjects) {
        super(size, OrderByConstants.ORDER_BY_ASC);
        this.storageEngine = engine;
        this.returnObjects = returnObjects;
    }

    public LazyBTreeCollection(int size, OrderByConstants orderByType) {
        super(size, orderByType);
    }

    @Override
    public IBTree buildTree(int degree) {
        return new InMemoryBTreeMultipleValuesPerKey("default", degree);
    }

    @Override
    public Iterator<T> iterator(OrderByConstants orderByType) {
        return new LazyODBBTreeIteratorMultiple(this.getTree(), orderByType, this.storageEngine, this.returnObjects);
    }
}

