/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.criteria;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.query.criteria.AbstractCriterion;
import org.neodatis.tool.wrappers.OdbString;

public class LikeCriterion
extends AbstractCriterion {
    private String criterionValue;
    private boolean isCaseSensitive;

    public LikeCriterion(String attributeName, String criterionValue, boolean isCaseSensiive) {
        super(attributeName);
        this.criterionValue = criterionValue;
        this.isCaseSensitive = isCaseSensiive;
    }

    @Override
    public boolean match(Object valueToMatch) {
        String regExp = null;
        if (valueToMatch == null) {
            return false;
        }
        if (valueToMatch instanceof AttributeValuesMap) {
            AttributeValuesMap attributeValues = (AttributeValuesMap)valueToMatch;
            valueToMatch = attributeValues.get(this.attributeName);
        }
        if (valueToMatch == null) {
            return false;
        }
        if (!(valueToMatch instanceof String)) {
            throw new ODBRuntimeException(NeoDatisError.QUERY_ATTRIBUTE_TYPE_NOT_SUPPORTED_IN_LIKE_EXPRESSION.addParameter(valueToMatch.getClass().getName()));
        }
        String value = (String)valueToMatch;
        if (this.criterionValue.indexOf("%") != -1) {
            regExp = OdbString.replaceToken(this.criterionValue, "%", "(.)*");
            if (this.isCaseSensitive) {
                return value != null && OdbString.matches(regExp, value);
            }
            return value != null && OdbString.matches(regExp.toLowerCase(), value.toLowerCase());
        }
        if (this.isCaseSensitive) {
            regExp = String.format("(.)*%s(.)*", this.criterionValue);
            return value != null && OdbString.matches(regExp, value);
        }
        regExp = String.format("(.)*%s(.)*", this.criterionValue.toLowerCase());
        return value != null && OdbString.matches(regExp, value.toLowerCase());
    }

    @Override
    public AttributeValuesMap getValues() {
        return new AttributeValuesMap();
    }

    @Override
    public void ready() {
    }
}

