/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.criteria;

import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.SimpleCompareKey;
import org.neodatis.odb.core.query.execution.GenericQueryExecutor;
import org.neodatis.odb.core.query.execution.IQueryExecutionPlan;
import org.neodatis.odb.core.query.execution.IndexTool;
import org.neodatis.odb.core.transaction.ITmpCache;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQueryExecutionPlan;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQueryManager;
import org.neodatis.tool.wrappers.list.IOdbList;

public class CriteriaQueryExecutor
extends GenericQueryExecutor {
    private IOdbList<String> involvedFields;
    private CriteriaQuery criteriaQuery;
    private CriteriaQueryManager manager;

    public CriteriaQueryExecutor(IQuery query, IStorageEngine engine) {
        super(query, engine);
        this.criteriaQuery = (CriteriaQuery)query;
        this.manager = new CriteriaQueryManager();
    }

    @Override
    public IQueryExecutionPlan getExecutionPlan() {
        CriteriaQueryExecutionPlan plan = new CriteriaQueryExecutionPlan(this.classInfo, (CriteriaQuery)this.query);
        return plan;
    }

    @Override
    public void prepareQuery() {
        this.criteriaQuery = (CriteriaQuery)this.query;
        this.criteriaQuery.setStorageEngine(this.storageEngine);
        this.involvedFields = this.criteriaQuery.getAllInvolvedFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matchObjectWithOid(OID oid, boolean returnObject, boolean inMemory) {
        this.currentOid = oid;
        ITmpCache tmpCache = this.session.getTmpCache();
        ObjectInfoHeader oih = null;
        try {
            if (!this.criteriaQuery.hasCriteria()) {
                if (inMemory || this.criteriaQuery.hasOrderBy()) {
                    this.currentNnoi = this.objectReader.readNonNativeObjectInfoFromOid(this.classInfo, this.currentOid, true, returnObject);
                    if (this.currentNnoi.isDeletedObject()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentOid = this.currentNnoi.getOid();
                    this.nextOID = this.currentNnoi.getNextObjectOID();
                } else {
                    oih = this.objectReader.readObjectInfoHeaderFromOid(this.currentOid, false);
                    this.nextOID = oih.getNextObjectOID();
                }
                boolean bl = true;
                return bl;
            }
            boolean optimizeObjectCompararison = this.criteriaQuery.optimizeObjectComparison();
            AttributeValuesMap attributeValues = this.objectReader.readObjectInfoValuesFromOID(this.classInfo, this.currentOid, true, this.involvedFields, this.involvedFields, 0, this.criteriaQuery.getOrderByFieldNames(), optimizeObjectCompararison);
            boolean objectMatches = this.manager.match(this.criteriaQuery, attributeValues);
            if (objectMatches) {
                this.currentNnoi = this.objectReader.readNonNativeObjectInfoFromOid(this.classInfo, this.currentOid, true, returnObject);
                this.currentOid = this.currentNnoi.getOid();
            }
            oih = attributeValues.getObjectInfoHeader();
            this.nextOID = oih.getNextObjectOID();
            boolean bl = objectMatches;
            return bl;
        }
        finally {
            tmpCache.clearObjectInfos();
        }
    }

    @Override
    public Comparable computeIndexKey(ClassInfo ci, ClassInfoIndex index) {
        CriteriaQuery q = (CriteriaQuery)this.query;
        AttributeValuesMap values = q.getCriteria().getValues();
        if (values.hasOid()) {
            return new SimpleCompareKey(values.getOid());
        }
        return IndexTool.computeKey(this.classInfo, index, (CriteriaQuery)this.query);
    }

    @Override
    public Object getCurrentObjectMetaRepresentation() {
        return this.currentNnoi;
    }

    @Override
    public String getFullClassName(IQuery query) {
        return this.manager.getFullClassName((CriteriaQuery)query);
    }
}

